/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import reactor.netty.Metrics;
import reactor.netty.channel.MeterKey;
import reactor.netty.http.MicrometerHttpMetricsRecorder;
import reactor.netty.http.server.HttpServerMetricsRecorder;

final class MicrometerHttpServerMetricsRecorder
extends MicrometerHttpMetricsRecorder
implements HttpServerMetricsRecorder {
    static final MicrometerHttpServerMetricsRecorder INSTANCE = new MicrometerHttpServerMetricsRecorder();

    private MicrometerHttpServerMetricsRecorder() {
        super("reactor.netty.http.server", "http");
    }

    @Override
    public void recordDataReceivedTime(String uri, String method2, Duration time) {
        Timer dataReceivedTime = this.dataReceivedTimeCache.computeIfAbsent(new MeterKey(uri, null, method2, null), key -> this.dataReceivedTimeBuilder.tags(new String[]{"uri", uri, "method", method2}).register(Metrics.REGISTRY));
        dataReceivedTime.record(time);
    }

    @Override
    public void recordDataSentTime(String uri, String method2, String status, Duration time) {
        Timer dataSentTime = this.dataSentTimeCache.computeIfAbsent(new MeterKey(uri, null, method2, status), key -> this.dataSentTimeBuilder.tags(new String[]{"uri", uri, "method", method2, "status", status}).register(Metrics.REGISTRY));
        dataSentTime.record(time);
    }

    @Override
    public void recordResponseTime(String uri, String method2, String status, Duration time) {
        Timer responseTime = this.responseTimeCache.computeIfAbsent(new MeterKey(uri, null, method2, status), key -> this.responseTimeBuilder.tags(new String[]{"uri", uri, "method", method2, "status", status}).register(Metrics.REGISTRY));
        responseTime.record(time);
    }
}

