/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.util.AttributeKey;
import java.util.function.BiPredicate;
import java.util.function.Function;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.server.HttpRequestDecoderSpec;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

final class HttpServerConfiguration {
    static final HttpServerConfiguration DEFAULT = new HttpServerConfiguration();
    static final AttributeKey<HttpServerConfiguration> CONF_KEY = AttributeKey.newInstance("httpServerConf");
    BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate = null;
    int minCompressionSize = -1;
    boolean forwarded = false;
    HttpRequestDecoderSpec decoder = new HttpRequestDecoderSpec();
    ServerCookieEncoder cookieEncoder = ServerCookieEncoder.STRICT;
    ServerCookieDecoder cookieDecoder = ServerCookieDecoder.STRICT;
    int protocols = 4;
    static final Function<ServerBootstrap, ServerBootstrap> MAP_COMPRESS = b -> {
        HttpServerConfiguration.getOrCreate((ServerBootstrap)b).minCompressionSize = 0;
        return b;
    };
    static final Function<ServerBootstrap, ServerBootstrap> MAP_NO_COMPRESS = b -> {
        HttpServerConfiguration c = HttpServerConfiguration.getOrCreate(b);
        c.minCompressionSize = -1;
        c.compressPredicate = null;
        return b;
    };
    static final Function<ServerBootstrap, ServerBootstrap> MAP_FORWARDED = b -> {
        HttpServerConfiguration.getOrCreate((ServerBootstrap)b).forwarded = true;
        return b;
    };
    static final Function<ServerBootstrap, ServerBootstrap> MAP_NO_FORWARDED = b -> {
        HttpServerConfiguration.getOrCreate((ServerBootstrap)b).forwarded = false;
        return b;
    };
    static final int h11 = 4;
    static final int h2 = 2;
    static final int h2c = 1;
    static final int h11orH2c = 5;
    static final int h11orH2 = 6;

    HttpServerConfiguration() {
    }

    static HttpServerConfiguration getAndClean(ServerBootstrap b) {
        HttpServerConfiguration hcc = (HttpServerConfiguration)b.config().attrs().get(CONF_KEY);
        if (hcc == null) {
            return DEFAULT;
        }
        b.attr(CONF_KEY, null);
        return hcc;
    }

    static HttpServerConfiguration getOrCreate(ServerBootstrap b) {
        HttpServerConfiguration hcc = (HttpServerConfiguration)b.config().attrs().get(CONF_KEY);
        if (hcc == null) {
            hcc = new HttpServerConfiguration();
            b.attr(CONF_KEY, hcc);
        }
        return hcc;
    }

    static ServerBootstrap compressSize(ServerBootstrap b, int minCompressionSize) {
        HttpServerConfiguration.getOrCreate((ServerBootstrap)b).minCompressionSize = minCompressionSize;
        return b;
    }

    static ServerBootstrap protocols(ServerBootstrap b, HttpProtocol ... protocols) {
        int _protocols = 0;
        for (HttpProtocol p : protocols) {
            if (p == HttpProtocol.HTTP11) {
                _protocols |= 4;
                continue;
            }
            if (p == HttpProtocol.H2) {
                _protocols |= 2;
                continue;
            }
            if (p != HttpProtocol.H2C) continue;
            _protocols |= 1;
        }
        HttpServerConfiguration.getOrCreate((ServerBootstrap)b).protocols = _protocols;
        return b;
    }

    static ServerBootstrap compressPredicate(ServerBootstrap b, BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate) {
        HttpServerConfiguration.getOrCreate((ServerBootstrap)b).compressPredicate = compressPredicate;
        return b;
    }

    static ServerBootstrap decoder(ServerBootstrap b, HttpRequestDecoderSpec decoder) {
        HttpServerConfiguration.getOrCreate((ServerBootstrap)b).decoder = decoder;
        return b;
    }

    static ServerBootstrap cookieCodec(ServerBootstrap b, ServerCookieEncoder encoder, ServerCookieDecoder decoder) {
        HttpServerConfiguration conf = HttpServerConfiguration.getOrCreate(b);
        conf.cookieEncoder = encoder;
        conf.cookieDecoder = decoder;
        return b;
    }
}

