/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty;

import io.netty.channel.Channel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import java.net.InetSocketAddress;
import java.time.Duration;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.netty.FutureMono;
import reactor.netty.ReactorNetty;

@FunctionalInterface
public interface DisposableChannel
extends Disposable {
    default public InetSocketAddress address() {
        Channel c = this.channel();
        if (c instanceof SocketChannel) {
            return ((SocketChannel)c).remoteAddress();
        }
        if (c instanceof ServerSocketChannel) {
            return ((ServerSocketChannel)c).localAddress();
        }
        if (c instanceof DatagramChannel) {
            InetSocketAddress a = ((DatagramChannel)c).remoteAddress();
            return a != null ? a : ((DatagramChannel)c).localAddress();
        }
        throw new IllegalStateException("Does not have an InetSocketAddress");
    }

    public Channel channel();

    @Override
    default public void dispose() {
        this.channel().close();
    }

    default public void disposeNow() {
        this.disposeNow(Duration.ofSeconds(3L));
    }

    default public void disposeNow(Duration timeout) {
        if (this.isDisposed()) {
            return;
        }
        this.dispose();
        try {
            this.onDispose().block(timeout);
        }
        catch (Exception e) {
            throw new IllegalStateException("Socket couldn't be stopped within " + timeout.toMillis() + "ms");
        }
    }

    default public CoreSubscriber<Void> disposeSubscriber() {
        return new ReactorNetty.ChannelDisposer(this);
    }

    @Override
    default public boolean isDisposed() {
        return !this.channel().isActive();
    }

    default public Mono<Void> onDispose() {
        return FutureMono.from(this.channel().closeFuture());
    }

    default public DisposableChannel onDispose(Disposable onDispose) {
        this.onDispose().subscribe(null, e -> onDispose.dispose(), onDispose::dispose);
        return this;
    }
}

