/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.methodhandler.fallback;

import feign.MethodMetadata;
import feign.Target;
import feign.Util;
import java.lang.reflect.Method;
import java.util.function.Function;
import reactivefeign.methodhandler.MethodHandler;
import reactivefeign.methodhandler.MethodHandlerFactory;
import reactivefeign.methodhandler.fallback.FallbackMethodHandler;

public class FallbackMethodHandlerFactory
implements MethodHandlerFactory {
    private final MethodHandlerFactory methodHandlerFactory;
    private final Function<Throwable, Object> fallbackFactory;
    private Target target;

    public FallbackMethodHandlerFactory(MethodHandlerFactory methodHandlerFactory, Function<Throwable, Object> fallbackFactory) {
        this.methodHandlerFactory = Util.checkNotNull(methodHandlerFactory, "methodHandlerFactory must not be null", new Object[0]);
        this.fallbackFactory = Util.checkNotNull(fallbackFactory, "fallbackFactory must be not null", new Object[0]);
    }

    @Override
    public void target(Target target) {
        this.target = target;
        this.methodHandlerFactory.target(target);
    }

    @Override
    public MethodHandler create(MethodMetadata metadata) {
        return new FallbackMethodHandler(this.target, metadata, this.methodHandlerFactory.create(metadata), this.fallbackFactory);
    }

    @Override
    public MethodHandler createDefault(Method method2) {
        return this.methodHandlerFactory.createDefault(method2);
    }
}

