/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign;

import feign.Contract;
import feign.InvocationHandlerFactory;
import feign.Target;
import reactivefeign.FallbackFactory;
import reactivefeign.ReactiveFeign;
import reactivefeign.ReactiveInvocationHandler;
import reactivefeign.ReactiveOptions;
import reactivefeign.client.ReactiveHttpExchangeFilterFunction;
import reactivefeign.client.ReactiveHttpRequestInterceptor;
import reactivefeign.client.ReactiveHttpResponseMapper;
import reactivefeign.client.log.ReactiveLoggerListener;
import reactivefeign.client.statushandler.ReactiveStatusHandler;
import reactivefeign.methodhandler.MethodHandlerFactory;
import reactivefeign.publisher.PublisherClientFactory;
import reactivefeign.retry.ReactiveRetryPolicy;

public interface ReactiveFeignBuilder<T> {
    public ReactiveFeignBuilder<T> contract(Contract var1);

    public ReactiveFeignBuilder<T> addExchangeFilterFunction(ReactiveHttpExchangeFilterFunction var1);

    public ReactiveFeignBuilder<T> addRequestInterceptor(ReactiveHttpRequestInterceptor var1);

    public ReactiveFeignBuilder<T> addLoggerListener(ReactiveLoggerListener var1);

    public ReactiveFeignBuilder<T> decode404();

    public ReactiveFeignBuilder<T> statusHandler(ReactiveStatusHandler var1);

    public ReactiveFeignBuilder<T> responseMapper(ReactiveHttpResponseMapper var1);

    public ReactiveFeignBuilder<T> retryWhen(ReactiveRetryPolicy var1);

    public ReactiveFeignBuilder<T> options(ReactiveOptions var1);

    public ReactiveFeignBuilder<T> fallback(T var1);

    public ReactiveFeignBuilder<T> fallbackFactory(FallbackFactory<T> var1);

    default public T target(Class<T> apiType, String url) {
        return this.target(new Target.HardCodedTarget<T>(apiType, url));
    }

    default public T target(Class<T> apiType, String name, String url) {
        if (name.equals(url)) {
            throw new IllegalArgumentException(String.format("Name is equal to url: name=[%s], url=[%s]", name, url));
        }
        if (!url.contains(name)) {
            throw new IllegalArgumentException(String.format("Name should be part of url: name=[%s], url=[%s]", name, url));
        }
        return this.target(new Target.HardCodedTarget<T>(apiType, name, url));
    }

    default public T target(Target<T> target) {
        return this.build().newInstance(target);
    }

    default public ReactiveFeign build() {
        return new ReactiveFeign(this.contract(), this.buildReactiveMethodHandlerFactory(this.buildReactiveClientFactory()), this.invocationHandlerFactory());
    }

    public Contract contract();

    default public InvocationHandlerFactory invocationHandlerFactory() {
        return new ReactiveInvocationHandler.Factory();
    }

    public MethodHandlerFactory buildReactiveMethodHandlerFactory(PublisherClientFactory var1);

    public PublisherClientFactory buildReactiveClientFactory();
}

