/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpEntity;
import org.springframework.http.RequestEntity;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.annotation.AbstractMessageReaderArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class HttpEntityMethodArgumentResolver
extends AbstractMessageReaderArgumentResolver {
    public HttpEntityMethodArgumentResolver(List<HttpMessageReader<?>> readers, ReactiveAdapterRegistry registry) {
        super(readers, registry);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.checkParameterTypeNoReactiveWrapper(parameter, type -> HttpEntity.class.equals(type) || RequestEntity.class.equals(type));
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext bindingContext, ServerWebExchange exchange2) {
        Class<?> entityType = parameter.getParameterType();
        return this.readBody(parameter.nested(), parameter, false, bindingContext, exchange2).map(body2 -> this.createEntity(body2, entityType, exchange2.getRequest())).defaultIfEmpty(this.createEntity(null, entityType, exchange2.getRequest()));
    }

    private Object createEntity(@Nullable Object body2, Class<?> entityType, ServerHttpRequest request) {
        return RequestEntity.class.equals(entityType) ? new RequestEntity<Object>(body2, request.getHeaders(), request.getMethod(), request.getURI()) : new HttpEntity<Object>(body2, request.getHeaders());
    }
}

