/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class WebClientUtils {
    WebClientUtils() {
    }

    public static <T> Mono<ResponseEntity<T>> toEntity(ClientResponse response, Mono<T> bodyMono) {
        return Mono.defer(() -> {
            HttpHeaders headers2 = response.headers().asHttpHeaders();
            int status = response.rawStatusCode();
            return bodyMono.map(body2 -> WebClientUtils.createEntity(body2, headers2, status)).switchIfEmpty(Mono.fromCallable(() -> WebClientUtils.createEntity(null, headers2, status)));
        });
    }

    public static <T> Mono<ResponseEntity<List<T>>> toEntityList(ClientResponse response, Publisher<T> body2) {
        return Mono.defer(() -> {
            HttpHeaders headers2 = response.headers().asHttpHeaders();
            int status = response.rawStatusCode();
            return Flux.from(body2).collectList().map(list -> WebClientUtils.createEntity(list, headers2, status));
        });
    }

    public static <T> ResponseEntity<T> createEntity(@Nullable T body2, HttpHeaders headers2, int status) {
        HttpStatus resolvedStatus = HttpStatus.resolve(status);
        return resolvedStatus != null ? new ResponseEntity<T>(body2, (MultiValueMap<String, String>)headers2, resolvedStatus) : ((ResponseEntity.BodyBuilder)ResponseEntity.status(status).headers(headers2)).body(body2);
    }
}

