/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.server.HTTP2ServerConnection;
import org.eclipse.jetty.http2.server.HttpChannelOverHTTP2;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public class HttpTransportOverHTTP2
implements HttpTransport {
    private static final Logger LOG = Log.getLogger(HttpTransportOverHTTP2.class);
    private final AtomicBoolean commit = new AtomicBoolean();
    private final TransportCallback transportCallback = new TransportCallback();
    private final Connector connector;
    private final HTTP2ServerConnection connection;
    private IStream stream;
    private MetaData metaData;

    public HttpTransportOverHTTP2(Connector connector, HTTP2ServerConnection connection) {
        this.connector = connector;
        this.connection = connection;
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return this.connection.getEndPoint().isOptimizedForDirectBuffers();
    }

    public IStream getStream() {
        return this.stream;
    }

    public void setStream(IStream stream) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} setStream {}", this, stream.getId());
        }
        this.stream = stream;
    }

    public void recycle() {
        this.stream = null;
        this.commit.set(false);
    }

    @Override
    public void send(MetaData.Response info, boolean isHeadRequest, final ByteBuffer content, final boolean lastContent, Callback callback) {
        boolean hasContent;
        boolean bl = hasContent = BufferUtil.hasContent(content) && !isHeadRequest;
        if (info != null) {
            boolean interimResponse;
            this.metaData = info;
            int status = info.getStatus();
            boolean bl2 = interimResponse = status == 100 || status == 102;
            if (interimResponse) {
                if (hasContent) {
                    callback.failed(new IllegalStateException("Interim response cannot have content"));
                } else if (this.transportCallback.start(callback, false)) {
                    this.sendHeadersFrame(info, false, this.transportCallback);
                }
            } else if (this.commit.compareAndSet(false, true)) {
                if (hasContent) {
                    Callback.Nested commitCallback = new Callback.Nested(callback){

                        @Override
                        public void succeeded() {
                            if (lastContent) {
                                HttpFields trailers = HttpTransportOverHTTP2.this.retrieveTrailers();
                                if (trailers != null) {
                                    if (HttpTransportOverHTTP2.this.transportCallback.start(new SendTrailers(this.getCallback(), trailers), false)) {
                                        HttpTransportOverHTTP2.this.sendDataFrame(content, true, false, HttpTransportOverHTTP2.this.transportCallback);
                                    }
                                } else if (HttpTransportOverHTTP2.this.transportCallback.start(this.getCallback(), false)) {
                                    HttpTransportOverHTTP2.this.sendDataFrame(content, true, true, HttpTransportOverHTTP2.this.transportCallback);
                                }
                            } else if (HttpTransportOverHTTP2.this.transportCallback.start(this.getCallback(), false)) {
                                HttpTransportOverHTTP2.this.sendDataFrame(content, false, false, HttpTransportOverHTTP2.this.transportCallback);
                            }
                        }
                    };
                    if (this.transportCallback.start(commitCallback, true)) {
                        this.sendHeadersFrame(info, false, this.transportCallback);
                    }
                } else if (lastContent) {
                    HttpFields trailers = this.retrieveTrailers();
                    if (trailers != null) {
                        if (this.transportCallback.start(new SendTrailers(callback, trailers), true)) {
                            this.sendHeadersFrame(info, false, this.transportCallback);
                        }
                    } else if (this.transportCallback.start(callback, true)) {
                        this.sendHeadersFrame(info, true, this.transportCallback);
                    }
                } else if (this.transportCallback.start(callback, true)) {
                    this.sendHeadersFrame(info, false, this.transportCallback);
                }
            } else {
                callback.failed(new IllegalStateException("committed"));
            }
        } else if (hasContent || lastContent) {
            if (lastContent) {
                HttpFields trailers = this.retrieveTrailers();
                if (trailers != null) {
                    SendTrailers sendTrailers = new SendTrailers(callback, trailers);
                    if (hasContent) {
                        if (this.transportCallback.start(sendTrailers, false)) {
                            this.sendDataFrame(content, true, false, this.transportCallback);
                        }
                    } else {
                        sendTrailers.succeeded();
                    }
                } else if (this.transportCallback.start(callback, false)) {
                    this.sendDataFrame(content, true, true, this.transportCallback);
                }
            } else if (this.transportCallback.start(callback, false)) {
                this.sendDataFrame(content, false, false, this.transportCallback);
            }
        } else {
            callback.succeeded();
        }
    }

    private HttpFields retrieveTrailers() {
        Supplier<HttpFields> supplier = this.metaData.getTrailerSupplier();
        if (supplier == null) {
            return null;
        }
        HttpFields trailers = supplier.get();
        if (trailers == null) {
            return null;
        }
        return trailers.size() == 0 ? null : trailers;
    }

    @Override
    public boolean isPushSupported() {
        return this.stream.getSession().isPushEnabled();
    }

    @Override
    public void push(final MetaData.Request request) {
        if (!this.stream.getSession().isPushEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP/2 Push disabled for {}", request);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP/2 Push {}", request);
        }
        this.stream.push(new PushPromiseFrame(this.stream.getId(), 0, request), new Promise<Stream>(){

            @Override
            public void succeeded(Stream pushStream) {
                HttpTransportOverHTTP2.this.connection.push(HttpTransportOverHTTP2.this.connector, (IStream)pushStream, request);
            }

            @Override
            public void failed(Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not push " + request, x);
                }
            }
        }, new Stream.Listener.Adapter());
    }

    private void sendHeadersFrame(MetaData.Response info, boolean endStream, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}:{}{} {}{}{}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), System.lineSeparator(), HttpVersion.HTTP_2, info.getStatus(), System.lineSeparator(), info.getFields()});
        }
        HeadersFrame frame = new HeadersFrame(this.stream.getId(), info, null, endStream);
        this.stream.headers(frame, callback);
    }

    private void sendDataFrame(ByteBuffer content, boolean lastContent, boolean endStream, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}: {} content bytes{}", this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), content.remaining(), lastContent ? " (last chunk)" : "");
        }
        DataFrame frame = new DataFrame(this.stream.getId(), content, endStream);
        this.stream.data(frame, callback);
    }

    private void sendTrailersFrame(MetaData metaData, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}: trailers", this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()));
        }
        HeadersFrame frame = new HeadersFrame(this.stream.getId(), metaData, null, true);
        this.stream.headers(frame, callback);
    }

    public void onStreamFailure(Throwable failure) {
        this.transportCallback.failed(failure);
    }

    public boolean onStreamTimeout(Throwable failure) {
        return this.transportCallback.onIdleTimeout(failure);
    }

    @Override
    public void onCompleted() {
        HttpChannelOverHTTP2 channel;
        if (!this.stream.isClosed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #{}: unconsumed request content, resetting stream", this.stream.getId());
            }
            this.stream.reset(new ResetFrame(this.stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
        }
        if ((channel = (HttpChannelOverHTTP2)this.stream.getAttachment()) != null) {
            channel.consumeInput();
        }
    }

    @Override
    public void abort(Throwable failure) {
        IStream stream = this.stream;
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{} aborted", stream == null ? -1 : stream.getId(), stream == null ? Integer.valueOf(-1) : Integer.toHexString(stream.getSession().hashCode()));
        }
        if (stream != null) {
            stream.reset(new ResetFrame(stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
        }
    }

    private class SendTrailers
    extends Callback.Nested {
        private final HttpFields trailers;

        private SendTrailers(Callback callback, HttpFields trailers) {
            super(callback);
            this.trailers = trailers;
        }

        @Override
        public void succeeded() {
            if (HttpTransportOverHTTP2.this.transportCallback.start(this.getCallback(), false)) {
                HttpTransportOverHTTP2.this.sendTrailersFrame(new MetaData(HttpVersion.HTTP_2, this.trailers), HttpTransportOverHTTP2.this.transportCallback);
            }
        }
    }

    private static enum State {
        IDLE,
        WRITING,
        FAILED,
        TIMEOUT;

    }

    private class TransportCallback
    implements Callback {
        private State state = State.IDLE;
        private Callback callback;
        private Throwable failure;
        private boolean commit;

        private TransportCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean start(Callback callback, boolean commit) {
            Throwable failure;
            State state;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                state = this.state;
                failure = this.failure;
                if (state == State.IDLE) {
                    this.state = State.WRITING;
                    this.callback = callback;
                    this.commit = commit;
                    return true;
                }
            }
            if (failure == null) {
                failure = new IllegalStateException("Invalid transport state: " + (Object)((Object)state));
            }
            callback.failed(failure);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void succeeded() {
            boolean commit;
            Callback callback = null;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                commit = this.commit;
                if (this.state == State.WRITING) {
                    this.state = State.IDLE;
                    callback = this.callback;
                    this.callback = null;
                    this.commit = false;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #{}/{} {} {}", HttpTransportOverHTTP2.this.stream.getId(), Integer.toHexString(HttpTransportOverHTTP2.this.stream.getSession().hashCode()), commit ? "commit" : "flush", callback == null ? "failure" : "success");
            }
            if (callback != null) {
                callback.succeeded();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable failure) {
            Callback callback;
            boolean commit;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                commit = this.commit;
                this.state = State.FAILED;
                callback = this.callback;
                this.callback = null;
                this.failure = failure;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("HTTP2 Response #%d/%h %s %s", HttpTransportOverHTTP2.this.stream.getId(), HttpTransportOverHTTP2.this.stream.getSession(), commit ? "commit" : "flush", callback == null ? "ignored" : "failed"), failure);
            }
            if (callback != null) {
                callback.failed(failure);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean onIdleTimeout(Throwable failure) {
            boolean result;
            Callback callback = null;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                boolean bl = result = this.state == State.WRITING;
                if (result) {
                    this.state = State.TIMEOUT;
                    callback = this.callback;
                    this.callback = null;
                    this.failure = failure;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("HTTP2 Response #%d/%h idle timeout %s", HttpTransportOverHTTP2.this.stream.getId(), HttpTransportOverHTTP2.this.stream.getSession(), result ? "expired" : "ignored"), failure);
            }
            if (result) {
                callback.failed(failure);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Invocable.InvocationType getInvocationType() {
            Callback callback;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                callback = this.callback;
            }
            return callback != null ? callback.getInvocationType() : Callback.super.getInvocationType();
        }
    }
}

