/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ServletPathSpec
extends PathSpec {
    private static final Logger LOG = Log.getLogger(ServletPathSpec.class);

    public static String normalize(String pathSpec) {
        if (StringUtil.isNotBlank(pathSpec) && !pathSpec.startsWith("/") && !pathSpec.startsWith("*")) {
            return "/" + pathSpec;
        }
        return pathSpec;
    }

    public ServletPathSpec(String servletPathSpec) {
        if (servletPathSpec == null) {
            servletPathSpec = "";
        }
        if (servletPathSpec.startsWith("servlet|")) {
            servletPathSpec = servletPathSpec.substring("servlet|".length());
        }
        this.assertValidServletPathSpec(servletPathSpec);
        if (servletPathSpec.isEmpty()) {
            this.pathSpec = "";
            this.pathDepth = -1;
            this.specLength = 1;
            this.group = PathSpecGroup.ROOT;
            return;
        }
        if ("/".equals(servletPathSpec)) {
            this.pathSpec = "/";
            this.pathDepth = -1;
            this.specLength = 1;
            this.group = PathSpecGroup.DEFAULT;
            return;
        }
        this.specLength = servletPathSpec.length();
        this.pathDepth = 0;
        char lastChar = servletPathSpec.charAt(this.specLength - 1);
        if (servletPathSpec.charAt(0) == '/' && servletPathSpec.endsWith("/*")) {
            this.group = PathSpecGroup.PREFIX_GLOB;
            this.prefix = servletPathSpec.substring(0, this.specLength - 2);
        } else if (servletPathSpec.charAt(0) == '*' && servletPathSpec.length() > 1) {
            this.group = PathSpecGroup.SUFFIX_GLOB;
            this.suffix = servletPathSpec.substring(2, this.specLength);
        } else {
            this.group = PathSpecGroup.EXACT;
            this.prefix = servletPathSpec;
            if (servletPathSpec.endsWith("*")) {
                LOG.warn("Suspicious URL pattern: '{}'; see sections 12.1 and 12.2 of the Servlet specification", servletPathSpec);
            }
        }
        for (int i2 = 0; i2 < this.specLength; ++i2) {
            int cp = servletPathSpec.codePointAt(i2);
            if (cp >= 128) continue;
            char c = (char)cp;
            switch (c) {
                case '/': {
                    ++this.pathDepth;
                }
            }
        }
        this.pathSpec = servletPathSpec;
    }

    private void assertValidServletPathSpec(String servletPathSpec) {
        if (servletPathSpec == null || servletPathSpec.equals("")) {
            return;
        }
        int len = servletPathSpec.length();
        if (servletPathSpec.charAt(0) == '/') {
            if (len == 1) {
                return;
            }
            int idx = servletPathSpec.indexOf(42);
            if (idx < 0) {
                return;
            }
            if (idx != len - 1) {
                throw new IllegalArgumentException("Servlet Spec 12.2 violation: glob '*' can only exist at end of prefix based matches: bad spec \"" + servletPathSpec + "\"");
            }
        } else if (servletPathSpec.startsWith("*.")) {
            int idx = servletPathSpec.indexOf(47);
            if (idx >= 0) {
                throw new IllegalArgumentException("Servlet Spec 12.2 violation: suffix based path spec cannot have path separators: bad spec \"" + servletPathSpec + "\"");
            }
            idx = servletPathSpec.indexOf(42, 2);
            if (idx >= 1) {
                throw new IllegalArgumentException("Servlet Spec 12.2 violation: suffix based path spec cannot have multiple glob '*': bad spec \"" + servletPathSpec + "\"");
            }
        } else {
            throw new IllegalArgumentException("Servlet Spec 12.2 violation: path spec must start with \"/\" or \"*.\": bad spec \"" + servletPathSpec + "\"");
        }
    }

    @Override
    public String getPathInfo(String path2) {
        if (this.group == PathSpecGroup.PREFIX_GLOB) {
            if (path2.length() == this.specLength - 2) {
                return null;
            }
            return path2.substring(this.specLength - 2);
        }
        return null;
    }

    @Override
    public String getPathMatch(String path2) {
        switch (this.group) {
            case EXACT: {
                if (this.pathSpec.equals(path2)) {
                    return path2;
                }
                return null;
            }
            case PREFIX_GLOB: {
                if (this.isWildcardMatch(path2)) {
                    return path2.substring(0, this.specLength - 2);
                }
                return null;
            }
            case SUFFIX_GLOB: {
                if (path2.regionMatches(path2.length() - (this.specLength - 1), this.pathSpec, 1, this.specLength - 1)) {
                    return path2;
                }
                return null;
            }
            case DEFAULT: {
                return path2;
            }
        }
        return null;
    }

    @Override
    public String getRelativePath(String base, String path2) {
        String info = this.getPathInfo(path2);
        if (info == null) {
            info = path2;
        }
        if (info.startsWith("./")) {
            info = info.substring(2);
        }
        path2 = base.endsWith("/") ? (info.startsWith("/") ? base + info.substring(1) : base + info) : (info.startsWith("/") ? base + info : base + "/" + info);
        return path2;
    }

    private boolean isWildcardMatch(String path2) {
        int cpl = this.specLength - 2;
        if (this.group == PathSpecGroup.PREFIX_GLOB && path2.regionMatches(0, this.pathSpec, 0, cpl)) {
            return path2.length() == cpl || '/' == path2.charAt(cpl);
        }
        return false;
    }

    @Override
    public boolean matches(String path2) {
        switch (this.group) {
            case EXACT: {
                return this.pathSpec.equals(path2);
            }
            case PREFIX_GLOB: {
                return this.isWildcardMatch(path2);
            }
            case SUFFIX_GLOB: {
                return path2.regionMatches(path2.length() - this.specLength + 1, this.pathSpec, 1, this.specLength - 1);
            }
            case ROOT: {
                return "/".equals(path2);
            }
            case DEFAULT: {
                return true;
            }
        }
        return false;
    }
}

