/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.codec.LoggingCodecSupport;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.DefaultClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import reactor.core.publisher.Mono;

public abstract class ExchangeFunctions {
    private static final Log logger = LogFactory.getLog(ExchangeFunctions.class);

    public static ExchangeFunction create(ClientHttpConnector connector) {
        return ExchangeFunctions.create(connector, ExchangeStrategies.withDefaults());
    }

    public static ExchangeFunction create(ClientHttpConnector connector, ExchangeStrategies strategies) {
        return new DefaultExchangeFunction(connector, strategies);
    }

    private static class DefaultExchangeFunction
    implements ExchangeFunction {
        private final ClientHttpConnector connector;
        private final ExchangeStrategies strategies;
        private boolean enableLoggingRequestDetails;

        public DefaultExchangeFunction(ClientHttpConnector connector, ExchangeStrategies strategies) {
            Assert.notNull((Object)connector, "ClientHttpConnector must not be null");
            Assert.notNull((Object)strategies, "ExchangeStrategies must not be null");
            this.connector = connector;
            this.strategies = strategies;
            strategies.messageWriters().stream().filter(LoggingCodecSupport.class::isInstance).forEach(reader -> {
                if (((LoggingCodecSupport)((Object)reader)).isEnableLoggingRequestDetails()) {
                    this.enableLoggingRequestDetails = true;
                }
            });
        }

        @Override
        public Mono<ClientResponse> exchange(ClientRequest clientRequest) {
            Assert.notNull((Object)clientRequest, "ClientRequest must not be null");
            HttpMethod httpMethod = clientRequest.method();
            URI url = clientRequest.url();
            String logPrefix = clientRequest.logPrefix();
            return this.connector.connect(httpMethod, url, httpRequest -> clientRequest.writeTo((ClientHttpRequest)httpRequest, this.strategies)).doOnRequest(n -> this.logRequest(clientRequest)).doOnCancel(() -> logger.debug(logPrefix + "Cancel signal (to close connection)")).map(httpResponse -> {
                this.logResponse((ClientHttpResponse)httpResponse, logPrefix);
                return new DefaultClientResponse((ClientHttpResponse)httpResponse, this.strategies, logPrefix, httpMethod.name() + " " + url, () -> this.createRequest(clientRequest));
            });
        }

        private void logRequest(ClientRequest request) {
            LogFormatUtils.traceDebug(logger, traceOn -> request.logPrefix() + "HTTP " + (Object)((Object)request.method()) + " " + request.url() + (traceOn != false ? ", headers=" + this.formatHeaders(request.headers()) : ""));
        }

        private void logResponse(ClientHttpResponse response, String logPrefix) {
            LogFormatUtils.traceDebug(logger, traceOn -> {
                int code = response.getRawStatusCode();
                HttpStatus status = HttpStatus.resolve(code);
                return logPrefix + "Response " + (status != null ? status : Integer.valueOf(code)) + (traceOn != false ? ", headers=" + this.formatHeaders(response.getHeaders()) : "");
            });
        }

        private String formatHeaders(HttpHeaders headers2) {
            return this.enableLoggingRequestDetails ? headers2.toString() : (headers2.isEmpty() ? "{}" : "{masked}");
        }

        private HttpRequest createRequest(final ClientRequest request) {
            return new HttpRequest(){

                @Override
                public HttpMethod getMethod() {
                    return request.method();
                }

                @Override
                public String getMethodValue() {
                    return request.method().name();
                }

                @Override
                public URI getURI() {
                    return request.url();
                }

                @Override
                public HttpHeaders getHeaders() {
                    return request.headers();
                }
            };
        }
    }
}

