/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import java.io.Serializable;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.fraction.BigFractionField;
import org.apache.commons.math3.fraction.FractionConversionException;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.RealMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KolmogorovSmirnovDistribution
implements Serializable {
    private static final long serialVersionUID = -4670676796862967187L;
    private int n;

    public KolmogorovSmirnovDistribution(int n) throws NotStrictlyPositiveException {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_NUMBER_OF_SAMPLES, n);
        }
        this.n = n;
    }

    public double cdf(double d) throws MathArithmeticException {
        return this.cdf(d, false);
    }

    public double cdfExact(double d) throws MathArithmeticException {
        return this.cdf(d, true);
    }

    public double cdf(double d, boolean exact) throws MathArithmeticException {
        double ninv = 1.0 / (double)this.n;
        double ninvhalf = 0.5 * ninv;
        if (d <= ninvhalf) {
            return 0.0;
        }
        if (ninvhalf < d && d <= ninv) {
            double res = 1.0;
            double f = 2.0 * d - ninv;
            for (int i2 = 1; i2 <= this.n; ++i2) {
                res *= (double)i2 * f;
            }
            return res;
        }
        if (1.0 - ninv <= d && d < 1.0) {
            return 1.0 - 2.0 * Math.pow(1.0 - d, this.n);
        }
        if (1.0 <= d) {
            return 1.0;
        }
        return exact ? this.exactK(d) : this.roundedK(d);
    }

    private double exactK(double d) throws MathArithmeticException {
        int k = (int)Math.ceil((double)this.n * d);
        FieldMatrix<BigFraction> H = this.createH(d);
        FieldMatrix<BigFraction> Hpower = H.power(this.n);
        BigFraction pFrac = Hpower.getEntry(k - 1, k - 1);
        for (int i2 = 1; i2 <= this.n; ++i2) {
            pFrac = pFrac.multiply(i2).divide(this.n);
        }
        return pFrac.bigDecimalValue(20, 4).doubleValue();
    }

    private double roundedK(double d) throws MathArithmeticException {
        int k = (int)Math.ceil((double)this.n * d);
        FieldMatrix<BigFraction> HBigFraction = this.createH(d);
        int m3 = HBigFraction.getRowDimension();
        Array2DRowRealMatrix H = new Array2DRowRealMatrix(m3, m3);
        for (int i2 = 0; i2 < m3; ++i2) {
            for (int j = 0; j < m3; ++j) {
                H.setEntry(i2, j, HBigFraction.getEntry(i2, j).doubleValue());
            }
        }
        RealMatrix Hpower = H.power(this.n);
        double pFrac = Hpower.getEntry(k - 1, k - 1);
        for (int i3 = 1; i3 <= this.n; ++i3) {
            pFrac *= (double)i3 / (double)this.n;
        }
        return pFrac;
    }

    private FieldMatrix<BigFraction> createH(double d) throws NumberIsTooLargeException, FractionConversionException {
        int i2;
        int k = (int)Math.ceil((double)this.n * d);
        int m3 = 2 * k - 1;
        double hDouble = (double)k - (double)this.n * d;
        if (hDouble >= 1.0) {
            throw new NumberIsTooLargeException(hDouble, (Number)1.0, false);
        }
        BigFraction h2 = null;
        try {
            h2 = new BigFraction(hDouble, 1.0E-20, 10000);
        }
        catch (FractionConversionException e1) {
            try {
                h2 = new BigFraction(hDouble, 1.0E-10, 10000);
            }
            catch (FractionConversionException e2) {
                h2 = new BigFraction(hDouble, 1.0E-5, 10000);
            }
        }
        FieldElement[][] Hdata = new BigFraction[m3][m3];
        for (int i3 = 0; i3 < m3; ++i3) {
            for (int j = 0; j < m3; ++j) {
                Hdata[i3][j] = i3 - j + 1 < 0 ? BigFraction.ZERO : BigFraction.ONE;
            }
        }
        BigFraction[] hPowers = new BigFraction[m3];
        hPowers[0] = h2;
        for (i2 = 1; i2 < m3; ++i2) {
            hPowers[i2] = h2.multiply(hPowers[i2 - 1]);
        }
        for (i2 = 0; i2 < m3; ++i2) {
            Hdata[i2][0] = Hdata[i2][0].subtract(hPowers[i2]);
            Hdata[m3 - 1][i2] = ((BigFraction)Hdata[m3 - 1][i2]).subtract(hPowers[m3 - i2 - 1]);
        }
        if (h2.compareTo(BigFraction.ONE_HALF) == 1) {
            Hdata[m3 - 1][0] = ((BigFraction)Hdata[m3 - 1][0]).add(h2.multiply(2).subtract(1).pow(m3));
        }
        for (i2 = 0; i2 < m3; ++i2) {
            for (int j = 0; j < i2 + 1; ++j) {
                if (i2 - j + 1 <= 0) continue;
                for (int g2 = 2; g2 <= i2 - j + 1; ++g2) {
                    Hdata[i2][j] = ((BigFraction)Hdata[i2][j]).divide(g2);
                }
            }
        }
        return new Array2DRowFieldMatrix((Field)BigFractionField.getInstance(), Hdata);
    }
}

