/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.internal.shaded.reactor.pool;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.publisher.Mono;
import reactor.netty.internal.shaded.reactor.pool.AbstractPool;
import reactor.netty.internal.shaded.reactor.pool.PoolAcquirePendingLimitException;
import reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import reactor.netty.internal.shaded.reactor.pool.PoolShutdownException;
import reactor.netty.internal.shaded.reactor.pool.SimplePool;

final class SimpleLifoPool<POOLABLE>
extends SimplePool<POOLABLE> {
    private static final ConcurrentLinkedDeque TERMINATED = new ConcurrentLinkedDeque();
    volatile ConcurrentLinkedDeque<AbstractPool.Borrower<POOLABLE>> pending = new ConcurrentLinkedDeque();
    private static final AtomicReferenceFieldUpdater<SimpleLifoPool, ConcurrentLinkedDeque> PENDING = AtomicReferenceFieldUpdater.newUpdater(SimpleLifoPool.class, ConcurrentLinkedDeque.class, "pending");

    public SimpleLifoPool(PoolConfig<POOLABLE> poolConfig) {
        super(poolConfig);
    }

    @Override
    boolean pendingOffer(AbstractPool.Borrower<POOLABLE> pending) {
        int currentPending;
        int maxPending = this.poolConfig.maxPending();
        do {
            currentPending = PENDING_COUNT.get(this);
            if (maxPending < 0 || currentPending != maxPending) continue;
            pending.fail(new PoolAcquirePendingLimitException(maxPending));
            return false;
        } while (!PENDING_COUNT.compareAndSet(this, currentPending, currentPending + 1));
        this.pending.offerFirst(pending);
        return true;
    }

    @Override
    AbstractPool.Borrower<POOLABLE> pendingPoll() {
        ConcurrentLinkedDeque<AbstractPool.Borrower<POOLABLE>> q = this.pending;
        AbstractPool.Borrower<POOLABLE> b = q.pollFirst();
        if (b != null) {
            PENDING_COUNT.decrementAndGet(this);
        }
        return b;
    }

    @Override
    void cancelAcquire(AbstractPool.Borrower<POOLABLE> borrower) {
        ConcurrentLinkedDeque<AbstractPool.Borrower<POOLABLE>> q;
        if (!this.isDisposed() && (q = this.pending).remove(borrower)) {
            PENDING_COUNT.decrementAndGet(this);
        }
    }

    @Override
    public Mono<Void> disposeLater() {
        return Mono.defer(() -> {
            ConcurrentLinkedDeque q = PENDING.getAndSet(this, TERMINATED);
            if (q != TERMINATED) {
                AbstractPool.Borrower p;
                while ((p = (AbstractPool.Borrower)q.pollFirst()) != null) {
                    p.fail(new PoolShutdownException());
                }
                Queue e = ELEMENTS.getAndSet(this, null);
                if (e != null) {
                    Mono<Object> destroyMonos = Mono.empty();
                    while (!e.isEmpty()) {
                        SimplePool.QueuePooledRef ref = (SimplePool.QueuePooledRef)e.poll();
                        if (!ref.markInvalidate()) continue;
                        destroyMonos = destroyMonos.and(this.destroyPoolable(ref));
                    }
                    return destroyMonos;
                }
            }
            return Mono.empty();
        });
    }

    @Override
    public boolean isDisposed() {
        return PENDING.get(this) == TERMINATED;
    }
}

