/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.springframework.context.Lifecycle;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class JettyRequestUpgradeStrategy
implements RequestUpgradeStrategy,
Lifecycle {
    private static final ThreadLocal<WebSocketHandlerContainer> adapterHolder = new NamedThreadLocal<WebSocketHandlerContainer>("JettyWebSocketHandlerAdapter");
    @Nullable
    private WebSocketPolicy webSocketPolicy;
    @Nullable
    private WebSocketServerFactory factory;
    @Nullable
    private volatile ServletContext servletContext;
    private volatile boolean running = false;
    private final Object lifecycleMonitor = new Object();

    public void setWebSocketPolicy(WebSocketPolicy webSocketPolicy) {
        this.webSocketPolicy = webSocketPolicy;
    }

    @Nullable
    public WebSocketPolicy getWebSocketPolicy() {
        return this.webSocketPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            ServletContext servletContext = this.servletContext;
            if (!this.isRunning() && servletContext != null) {
                try {
                    this.factory = this.webSocketPolicy != null ? new WebSocketServerFactory(servletContext, this.webSocketPolicy) : new WebSocketServerFactory(servletContext);
                    this.factory.setCreator((request, response) -> {
                        WebSocketHandlerContainer container = adapterHolder.get();
                        String protocol = container.getProtocol();
                        if (protocol != null) {
                            response.setAcceptedSubProtocol(protocol);
                        }
                        return container.getAdapter();
                    });
                    this.factory.start();
                    this.running = true;
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Unable to start WebSocketServerFactory", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning() && this.factory != null) {
                try {
                    this.factory.stop();
                    this.running = false;
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Failed to stop WebSocketServerFactory", ex);
                }
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange2, WebSocketHandler handler, @Nullable String subProtocol, Supplier<HandshakeInfo> handshakeInfoFactory) {
        ServerHttpRequest request = exchange2.getRequest();
        ServerHttpResponse response = exchange2.getResponse();
        HttpServletRequest servletRequest = JettyRequestUpgradeStrategy.getNativeRequest(request);
        HttpServletResponse servletResponse = JettyRequestUpgradeStrategy.getNativeResponse(response);
        HandshakeInfo handshakeInfo = handshakeInfoFactory.get();
        DataBufferFactory factory = response.bufferFactory();
        JettyWebSocketHandlerAdapter adapter = new JettyWebSocketHandlerAdapter(handler, session -> new JettyWebSocketSession((Session)session, handshakeInfo, factory));
        this.startLazily(servletRequest);
        Assert.state(this.factory != null, "No WebSocketServerFactory available");
        boolean isUpgrade = this.factory.isUpgradeRequest(servletRequest, servletResponse);
        Assert.isTrue(isUpgrade, "Not a WebSocket handshake");
        return exchange2.getResponse().setComplete().then(Mono.fromCallable(() -> {
            try {
                adapterHolder.set(new WebSocketHandlerContainer(adapter, subProtocol));
                this.factory.acceptWebSocket(servletRequest, servletResponse);
            }
            finally {
                adapterHolder.remove();
            }
            return null;
        }));
    }

    private static HttpServletRequest getNativeRequest(ServerHttpRequest request) {
        if (request instanceof AbstractServerHttpRequest) {
            return (HttpServletRequest)((AbstractServerHttpRequest)request).getNativeRequest();
        }
        if (request instanceof ServerHttpRequestDecorator) {
            return JettyRequestUpgradeStrategy.getNativeRequest(((ServerHttpRequestDecorator)request).getDelegate());
        }
        throw new IllegalArgumentException("Couldn't find HttpServletRequest in " + request.getClass().getName());
    }

    private static HttpServletResponse getNativeResponse(ServerHttpResponse response) {
        if (response instanceof AbstractServerHttpResponse) {
            return (HttpServletResponse)((AbstractServerHttpResponse)response).getNativeResponse();
        }
        if (response instanceof ServerHttpResponseDecorator) {
            return JettyRequestUpgradeStrategy.getNativeResponse(((ServerHttpResponseDecorator)response).getDelegate());
        }
        throw new IllegalArgumentException("Couldn't find HttpServletResponse in " + response.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLazily(HttpServletRequest request) {
        if (this.isRunning()) {
            return;
        }
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                this.servletContext = request.getServletContext();
                this.start();
            }
        }
    }

    private static class WebSocketHandlerContainer {
        private final JettyWebSocketHandlerAdapter adapter;
        @Nullable
        private final String protocol;

        public WebSocketHandlerContainer(JettyWebSocketHandlerAdapter adapter, @Nullable String protocol) {
            this.adapter = adapter;
            this.protocol = protocol;
        }

        public JettyWebSocketHandlerAdapter getAdapter() {
            return this.adapter;
        }

        @Nullable
        public String getProtocol() {
            return this.protocol;
        }
    }
}

