/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.matching.AbsentPattern;
import com.github.tomakehurst.wiremock.matching.AnythingPattern;
import com.github.tomakehurst.wiremock.matching.ContainsPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.MatchesJsonPathPattern;
import com.github.tomakehurst.wiremock.matching.MatchesXPathPattern;
import com.github.tomakehurst.wiremock.matching.NegativeRegexPattern;
import com.github.tomakehurst.wiremock.matching.RegexPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xmlunit.diff.ComparisonType;

public class StringValuePatternJsonDeserializer
extends JsonDeserializer<StringValuePattern> {
    private static final Map<String, Class<? extends StringValuePattern>> PATTERNS = new ImmutableMap.Builder<String, Class<EqualToPattern>>().put("equalTo", EqualToPattern.class).put("equalToJson", EqualToJsonPattern.class).put("matchesJsonPath", MatchesJsonPathPattern.class).put("equalToXml", EqualToXmlPattern.class).put("matchesXPath", MatchesXPathPattern.class).put("contains", ContainsPattern.class).put("matches", RegexPattern.class).put("doesNotMatch", NegativeRegexPattern.class).put("anything", AnythingPattern.class).put("absent", AbsentPattern.class).build();

    @Override
    public StringValuePattern deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        if (StringValuePatternJsonDeserializer.isAbsent(rootNode)) {
            return AbsentPattern.ABSENT;
        }
        return this.buildStringValuePattern(rootNode);
    }

    public StringValuePattern buildStringValuePattern(JsonNode rootNode) throws JsonMappingException {
        Class<? extends StringValuePattern> patternClass = StringValuePatternJsonDeserializer.findPatternClass(rootNode);
        if (patternClass.equals(EqualToJsonPattern.class)) {
            return this.deserializeEqualToJson(rootNode);
        }
        if (patternClass.equals(EqualToXmlPattern.class)) {
            return this.deserializeEqualToXml(rootNode);
        }
        if (patternClass.equals(MatchesJsonPathPattern.class)) {
            return this.deserialiseMatchesJsonPathPattern(rootNode);
        }
        if (patternClass.equals(MatchesXPathPattern.class)) {
            return this.deserialiseMatchesXPathPattern(rootNode);
        }
        if (patternClass.equals(EqualToPattern.class)) {
            return this.deserializeEqualTo(rootNode);
        }
        Constructor<? extends StringValuePattern> constructor = StringValuePatternJsonDeserializer.findConstructor(patternClass);
        Map.Entry<String, JsonNode> entry = Iterators.find(rootNode.fields(), new Predicate<Map.Entry<String, JsonNode>>(){

            @Override
            public boolean apply(Map.Entry<String, JsonNode> input) {
                return PATTERNS.keySet().contains(input.getKey());
            }
        });
        if (!entry.getValue().isTextual()) {
            throw new JsonMappingException(entry.getKey() + " operand must be a non-null string");
        }
        String operand = entry.getValue().textValue();
        try {
            return constructor.newInstance(operand);
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, StringValuePattern.class);
        }
    }

    private EqualToPattern deserializeEqualTo(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("equalTo")) {
            throw new JsonMappingException(rootNode.toString() + " is not a valid match operation");
        }
        JsonNode equalToNode = rootNode.findValue("equalTo");
        if (!equalToNode.isTextual()) {
            throw new JsonMappingException("equalTo operand must be a non-null string");
        }
        String operand = equalToNode.textValue();
        Boolean ignoreCase = StringValuePatternJsonDeserializer.fromNullable(rootNode.findValue("caseInsensitive"));
        return new EqualToPattern(operand, ignoreCase);
    }

    private EqualToJsonPattern deserializeEqualToJson(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("equalToJson")) {
            throw new JsonMappingException(rootNode.toString() + " is not a valid match operation");
        }
        JsonNode operand = rootNode.findValue("equalToJson");
        Boolean ignoreArrayOrder = StringValuePatternJsonDeserializer.fromNullable(rootNode.findValue("ignoreArrayOrder"));
        Boolean ignoreExtraElements = StringValuePatternJsonDeserializer.fromNullable(rootNode.findValue("ignoreExtraElements"));
        if (operand.isTextual()) {
            return new EqualToJsonPattern(operand.textValue(), ignoreArrayOrder, ignoreExtraElements);
        }
        return new EqualToJsonPattern(operand, ignoreArrayOrder, ignoreExtraElements);
    }

    private EqualToXmlPattern deserializeEqualToXml(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("equalToXml")) {
            throw new JsonMappingException(rootNode.toString() + " is not a valid match operation");
        }
        JsonNode operand = rootNode.findValue("equalToXml");
        Boolean enablePlaceholders = StringValuePatternJsonDeserializer.fromNullable(rootNode.findValue("enablePlaceholders"));
        String placeholderOpeningDelimiterRegex = StringValuePatternJsonDeserializer.fromNullableTextNode(rootNode.findValue("placeholderOpeningDelimiterRegex"));
        String placeholderClosingDelimiterRegex = StringValuePatternJsonDeserializer.fromNullableTextNode(rootNode.findValue("placeholderClosingDelimiterRegex"));
        Set<ComparisonType> exemptedComparisons = StringValuePatternJsonDeserializer.comparisonTypeSetFromArray(rootNode.findValue("exemptedComparisons"));
        return new EqualToXmlPattern(operand.textValue(), enablePlaceholders, placeholderOpeningDelimiterRegex, placeholderClosingDelimiterRegex, exemptedComparisons);
    }

    private MatchesJsonPathPattern deserialiseMatchesJsonPathPattern(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("matchesJsonPath")) {
            throw new JsonMappingException(rootNode.toString() + " is not a valid match operation");
        }
        JsonNode outerPatternNode = rootNode.findValue("matchesJsonPath");
        if (outerPatternNode.isTextual()) {
            return new MatchesJsonPathPattern(outerPatternNode.textValue());
        }
        if (!outerPatternNode.has("expression")) {
            throw new JsonMappingException("expression is required in the advanced matchesJsonPath form");
        }
        String expression = outerPatternNode.findValue("expression").textValue();
        StringValuePattern valuePattern = this.buildStringValuePattern(outerPatternNode);
        return new MatchesJsonPathPattern(expression, valuePattern);
    }

    private MatchesXPathPattern deserialiseMatchesXPathPattern(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("matchesXPath")) {
            throw new JsonMappingException(rootNode.toString() + " is not a valid match operation");
        }
        JsonNode namespacesNode = rootNode.findValue("xPathNamespaces");
        Map<String, String> namespaces = namespacesNode != null ? StringValuePatternJsonDeserializer.toNamespaceMap(namespacesNode) : Collections.emptyMap();
        JsonNode outerPatternNode = rootNode.findValue("matchesXPath");
        if (outerPatternNode.isTextual()) {
            return new MatchesXPathPattern(outerPatternNode.textValue(), namespaces);
        }
        if (!outerPatternNode.has("expression")) {
            throw new JsonMappingException("expression is required in the advanced matchesXPath form");
        }
        String expression = outerPatternNode.findValue("expression").textValue();
        StringValuePattern valuePattern = this.buildStringValuePattern(outerPatternNode);
        return new MatchesXPathPattern(expression, namespaces, valuePattern);
    }

    private static Map<String, String> toNamespaceMap(JsonNode namespacesNode) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        Iterator<Map.Entry<String, JsonNode>> fields = namespacesNode.fields();
        while (fields.hasNext()) {
            Map.Entry<String, JsonNode> field = fields.next();
            builder.put(field.getKey(), field.getValue().textValue());
        }
        return builder.build();
    }

    private static Boolean fromNullable(JsonNode node) {
        return node == null ? null : Boolean.valueOf(node.asBoolean());
    }

    private static String fromNullableTextNode(JsonNode node) {
        return node == null ? null : node.asText();
    }

    private static Set<ComparisonType> comparisonTypeSetFromArray(JsonNode node) {
        if (node == null || !node.isArray()) {
            return null;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonNode itemNode : node) {
            builder.add((Object)ComparisonType.valueOf(itemNode.textValue()));
        }
        return builder.build();
    }

    private static Constructor<? extends StringValuePattern> findConstructor(Class<? extends StringValuePattern> clazz) {
        Optional<Constructor<?>> optionalConstructor = Iterables.tryFind(Arrays.asList(clazz.getDeclaredConstructors()), new Predicate<Constructor<?>>(){

            @Override
            public boolean apply(Constructor<?> input) {
                return input.getParameterTypes().length == 1 && input.getGenericParameterTypes()[0].equals(String.class);
            }
        });
        if (!optionalConstructor.isPresent()) {
            throw new IllegalStateException("Constructor for " + clazz.getSimpleName() + " must have a single string argument constructor");
        }
        return optionalConstructor.get();
    }

    private static boolean isAbsent(JsonNode rootNode) {
        for (Map.Entry entry : ImmutableList.copyOf(rootNode.fields())) {
            if (!((String)entry.getKey()).equals("absent")) continue;
            return true;
        }
        return false;
    }

    private static Class<? extends StringValuePattern> findPatternClass(JsonNode rootNode) throws JsonMappingException {
        for (Map.Entry entry : ImmutableList.copyOf(rootNode.fields())) {
            Class<? extends StringValuePattern> patternClass = PATTERNS.get(entry.getKey());
            if (patternClass == null) continue;
            return patternClass;
        }
        throw new JsonMappingException(rootNode.toString() + " is not a valid match operation");
    }
}

