/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LoggingHandler;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.NetUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.tcp.InetSocketAddressUtil;
import reactor.netty.tcp.ProxyProvider;
import reactor.util.Logger;
import reactor.util.Loggers;

final class TcpUtils {
    static final Logger log = Loggers.getLogger(TcpUtils.class);
    static final ChannelOperations.OnSetup TCP_OPS = (ch, c, msg) -> new ChannelOperations(ch, c);

    TcpUtils() {
    }

    static Bootstrap updateProxySupport(Bootstrap b, ProxyProvider proxyOptions) {
        BootstrapHandlers.updateConfiguration(b, "reactor.left.proxyHandler", (BiConsumer<ConnectionObserver, ? super Channel>)new ProxySupportConsumer(b, proxyOptions));
        if (b.config().resolver() == DefaultAddressResolverGroup.INSTANCE) {
            return b.resolver(NoopAddressResolverGroup.INSTANCE);
        }
        return b;
    }

    static Bootstrap removeProxySupport(Bootstrap b) {
        BootstrapHandlers.removeConfiguration(b, "reactor.left.proxyHandler");
        return b;
    }

    static Bootstrap updateHost(Bootstrap b, String host) {
        return b.remoteAddress(TcpUtils._updateHost(b.config().remoteAddress(), host));
    }

    static ServerBootstrap updateHost(ServerBootstrap b, String host) {
        return (ServerBootstrap)b.localAddress(TcpUtils._updateHost(b.config().localAddress(), host));
    }

    static SocketAddress _updateHost(@Nullable SocketAddress address, String host) {
        if (!(address instanceof InetSocketAddress)) {
            return InetSocketAddressUtil.createUnresolved(host, 0);
        }
        InetSocketAddress inet = (InetSocketAddress)address;
        return InetSocketAddressUtil.createUnresolved(host, inet.getPort());
    }

    static Bootstrap updatePort(Bootstrap b, int port) {
        return b.remoteAddress(TcpUtils._updatePort(b.config().remoteAddress(), port));
    }

    static ServerBootstrap updatePort(ServerBootstrap b, int port) {
        return (ServerBootstrap)b.localAddress(TcpUtils._updatePort(b.config().localAddress(), port));
    }

    static SocketAddress _updatePort(@Nullable SocketAddress address, int port) {
        if (!(address instanceof InetSocketAddress)) {
            return InetSocketAddressUtil.createUnresolved(NetUtil.LOCALHOST.getHostAddress(), port);
        }
        InetSocketAddress inet = (InetSocketAddress)address;
        InetAddress addr = inet.getAddress();
        String host = addr == null ? inet.getHostName() : addr.getHostAddress();
        return InetSocketAddressUtil.createUnresolved(host, port);
    }

    static SocketAddressSupplier lazyAddress(Supplier<? extends SocketAddress> supplier) {
        return new SocketAddressSupplier(supplier);
    }

    static final class ProxySupportConsumer
    implements BiConsumer<ConnectionObserver, Channel> {
        final Bootstrap bootstrap;
        final ProxyProvider proxyProvider;

        ProxySupportConsumer(Bootstrap bootstrap, ProxyProvider proxyProvider) {
            this.bootstrap = bootstrap;
            this.proxyProvider = proxyProvider;
        }

        @Override
        public void accept(ConnectionObserver connectionObserver, Channel channel) {
            if (this.proxyProvider.shouldProxy(this.bootstrap.config().remoteAddress())) {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addFirst("reactor.left.proxyHandler", (ChannelHandler)this.proxyProvider.newProxyHandler());
                if (log.isDebugEnabled()) {
                    pipeline.addFirst(new LoggingHandler("reactor.netty.proxy"));
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProxySupportConsumer that = (ProxySupportConsumer)o;
            return Objects.equals(this.proxyProvider, that.proxyProvider);
        }

        public int hashCode() {
            return Objects.hash(this.proxyProvider);
        }
    }

    static final class SocketAddressSupplier
    extends SocketAddress
    implements Supplier<SocketAddress> {
        final Supplier<? extends SocketAddress> supplier;

        SocketAddressSupplier(Supplier<? extends SocketAddress> supplier) {
            this.supplier = Objects.requireNonNull(supplier, "Lazy address supplier must not be null");
        }

        @Override
        public SocketAddress get() {
            return this.supplier.get();
        }
    }
}

