/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientOperator;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpClient;

final class HttpClientSecure
extends HttpClientOperator {
    final reactor.netty.tcp.SslProvider sslProvider;
    static final Consumer<? super SslHandler> DEFAULT_HOSTNAME_VERIFICATION;
    static final reactor.netty.tcp.SslProvider DEFAULT_HTTP_SSL_PROVIDER;
    static final SslContext DEFAULT_CLIENT_HTTP2_CONTEXT;
    static final Consumer<SslProvider.SslContextSpec> SSL_DEFAULT_SPEC_HTTP2;

    static HttpClient secure(HttpClient client, Consumer<? super SslProvider.SslContextSpec> sslProviderBuilder) {
        Objects.requireNonNull(sslProviderBuilder, "sslProviderBuilder");
        SslProvider.SslContextSpec builder = reactor.netty.tcp.SslProvider.builder();
        sslProviderBuilder.accept(builder);
        return new HttpClientSecure(client, ((SslProvider.Builder)((Object)builder)).build());
    }

    HttpClientSecure(HttpClient client, @Nullable reactor.netty.tcp.SslProvider sslProvider) {
        super(client);
        this.sslProvider = sslProvider;
    }

    @Override
    protected TcpClient tcpConfiguration() {
        if (this.sslProvider == null) {
            return this.source.tcpConfiguration().secure(DEFAULT_HTTP_SSL_PROVIDER);
        }
        return this.source.tcpConfiguration().secure(reactor.netty.tcp.SslProvider.addHandlerConfigurator(this.sslProvider, DEFAULT_HOSTNAME_VERIFICATION));
    }

    static {
        SslContext sslCtx;
        DEFAULT_HOSTNAME_VERIFICATION = handler -> {
            SSLEngine sslEngine = handler.engine();
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParameters);
        };
        DEFAULT_HTTP_SSL_PROVIDER = reactor.netty.tcp.SslProvider.addHandlerConfigurator(reactor.netty.tcp.SslProvider.defaultClientProvider(), DEFAULT_HOSTNAME_VERIFICATION);
        try {
            SslProvider provider = OpenSsl.isAlpnSupported() ? SslProvider.OPENSSL : SslProvider.JDK;
            sslCtx = SslContextBuilder.forClient().sslProvider(provider).ciphers(Http2SecurityUtil.CIPHERS, SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, "h2", "http/1.1")).build();
        }
        catch (Exception e) {
            sslCtx = null;
        }
        DEFAULT_CLIENT_HTTP2_CONTEXT = sslCtx;
        SSL_DEFAULT_SPEC_HTTP2 = sslProviderBuilder -> sslProviderBuilder.sslContext(DEFAULT_CLIENT_HTTP2_CONTEXT);
    }
}

