/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client.metrics;

import feign.MethodMetadata;
import feign.RequestTemplate;
import feign.Target;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import reactivefeign.client.ReactiveFeignException;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.log.ReactiveLoggerListener;
import reactivefeign.client.metrics.MetricsTag;

public class MicrometerReactiveLogger
implements ReactiveLoggerListener<MetricsContext> {
    public static final String DEFAULT_TIMER_NAME = "reactive.feign.client.requests";
    private final Clock clock;
    private MeterRegistry meterRegistry;
    private String name;
    private Set<MetricsTag> tags;

    public static MicrometerReactiveLogger basicTimer() {
        return new MicrometerReactiveLogger(Clock.systemUTC(), (MeterRegistry)Metrics.globalRegistry, DEFAULT_TIMER_NAME, MetricsTag.getMandatory());
    }

    public MicrometerReactiveLogger(Clock clock, MeterRegistry meterRegistry, String name, Set<MetricsTag> tags) {
        this.clock = clock;
        this.meterRegistry = meterRegistry;
        this.name = name;
        this.tags = tags;
    }

    @Override
    public MetricsContext requestStarted(ReactiveHttpRequest request, Target target, MethodMetadata methodMetadata) {
        return new MetricsContext(request, target, methodMetadata, this.clock);
    }

    @Override
    public void responseReceived(ReactiveHttpResponse response, MetricsContext logContext) {
        this.meterRegistry.timer(this.name, MicrometerReactiveLogger.buildResponseTags(response, logContext, this.tags)).record(logContext.timeSpent(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void errorReceived(Throwable throwable, MetricsContext logContext) {
        this.meterRegistry.timer(this.name, MicrometerReactiveLogger.buildErrorTags(throwable, logContext, this.tags)).record(logContext.timeSpent(), TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean logRequestBody() {
        return false;
    }

    @Override
    public void bodySent(Object body2, MetricsContext logContext) {
    }

    @Override
    public boolean logResponseBody() {
        return false;
    }

    @Override
    public void bodyReceived(Object body2, MetricsContext logContext) {
    }

    private static List<Tag> buildResponseTags(ReactiveHttpResponse response, MetricsContext metricsContext, Set<MetricsTag> tags) {
        List<Tag> metricsTags = MicrometerReactiveLogger.buildTags(metricsContext, tags);
        if (tags.contains((Object)MetricsTag.HOST)) {
            metricsTags.add(Tag.of((String)MetricsTag.HOST.getTagName(), (String)response.request().uri().getHost()));
        }
        metricsTags.add(Tag.of((String)MetricsTag.STATUS.getTagName(), (String)Integer.toString(response.status())));
        return metricsTags;
    }

    private static List<Tag> buildErrorTags(Throwable ex, MetricsContext metricsContext, Set<MetricsTag> tags) {
        List<Tag> metricsTags = MicrometerReactiveLogger.buildTags(metricsContext, tags);
        if (tags.contains((Object)MetricsTag.HOST)) {
            if (ex instanceof ReactiveFeignException) {
                metricsTags.add(Tag.of((String)MetricsTag.HOST.getTagName(), (String)((ReactiveFeignException)ex).getRequest().uri().getHost()));
            } else {
                metricsTags.add(Tag.of((String)MetricsTag.HOST.getTagName(), (String)metricsContext.request.uri().getHost()));
            }
        }
        metricsTags.add(Tag.of((String)MetricsTag.STATUS.getTagName(), (String)Integer.toString(-1)));
        if (tags.contains((Object)MetricsTag.EXCEPTION)) {
            metricsTags.add(Tag.of((String)MetricsTag.EXCEPTION.getTagName(), (String)ex.getClass().getSimpleName()));
        }
        return metricsTags;
    }

    private static List<Tag> buildTags(MetricsContext metricsContext, Set<MetricsTag> tags) {
        RequestTemplate requestTemplate = metricsContext.methodMetadata.template();
        ArrayList<Tag> metricsTags = new ArrayList<Tag>(MetricsTag.values().length);
        metricsTags.add(Tag.of((String)MetricsTag.FEIGN_CLIENT_METHOD.getTagName(), (String)metricsContext.methodMetadata.configKey()));
        if (tags.contains((Object)MetricsTag.URI_TEMPLATE)) {
            metricsTags.add(Tag.of((String)MetricsTag.URI_TEMPLATE.getTagName(), (String)(metricsContext.target.url() + requestTemplate.url())));
        }
        if (tags.contains((Object)MetricsTag.HTTP_METHOD)) {
            metricsTags.add(Tag.of((String)MetricsTag.HTTP_METHOD.getTagName(), (String)requestTemplate.method()));
        }
        return metricsTags;
    }

    static class MetricsContext {
        private final ReactiveHttpRequest request;
        private final Target target;
        private final MethodMetadata methodMetadata;
        private final Clock clock;
        private final long startTime;

        public MetricsContext(ReactiveHttpRequest request, Target target, MethodMetadata methodMetadata, Clock clock) {
            this.request = request;
            this.target = target;
            this.methodMetadata = methodMetadata;
            this.clock = clock;
            this.startTime = clock.millis();
        }

        public long timeSpent() {
            return this.clock.millis() - this.startTime;
        }
    }
}

