/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client.metrics;

import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MetricsTag {
    FEIGN_CLIENT_METHOD("feignMethod", true),
    URI_TEMPLATE("uri", false),
    HTTP_METHOD("method", false),
    HOST("host", false),
    STATUS("status", true),
    EXCEPTION("exception", false);

    private String tagName;
    private boolean mandatory;

    private MetricsTag(String tagName, boolean mandatory) {
        this.tagName = tagName;
        this.mandatory = mandatory;
    }

    public String getTagName() {
        return this.tagName;
    }

    public static Set<MetricsTag> getMandatory() {
        return EnumSet.copyOf(Stream.of(MetricsTag.values()).filter(metricsTag -> metricsTag.mandatory).collect(Collectors.toList()));
    }
}

