/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign;

public abstract class ReactiveOptions {
    private final Boolean useHttp2;
    private final Long connectTimeoutMillis;
    private final Boolean acceptCompressed;

    protected ReactiveOptions(Boolean useHttp2, Long connectTimeoutMillis, Boolean acceptCompressed) {
        this.useHttp2 = useHttp2;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.acceptCompressed = acceptCompressed;
    }

    public Boolean getUseHttp2() {
        return this.useHttp2;
    }

    public Long getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public Boolean isTryUseCompression() {
        return this.acceptCompressed;
    }

    public boolean isEmpty() {
        return this.useHttp2 == null && this.connectTimeoutMillis == null && this.acceptCompressed == null;
    }

    public static boolean useHttp2(ReactiveOptions options) {
        return options != null && options.getUseHttp2() != null && options.getUseHttp2() != false;
    }

    public static abstract class Builder {
        protected Boolean useHttp2;
        protected Long connectTimeoutMillis;
        protected Boolean acceptCompressed;

        public Builder setUseHttp2(boolean useHttp2) {
            this.useHttp2 = useHttp2;
            return this;
        }

        public Builder setConnectTimeoutMillis(long connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        public Builder setAcceptCompressed(boolean acceptCompressed) {
            this.acceptCompressed = acceptCompressed;
            return this;
        }

        public abstract ReactiveOptions build();
    }
}

