/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import org.xmlunit.util.Linqy;
import org.xmlunit.util.Nodes;

public class XPathContext
implements Cloneable {
    private Deque<Level> path = new LinkedList<Level>();
    private final Map<String, String> uri2Prefix;
    private static final String COMMENT = "comment()";
    private static final String PI = "processing-instruction()";
    private static final String TEXT = "text()";
    private static final String OPEN = "[";
    private static final String CLOSE = "]";
    private static final String SEP = "/";
    private static final String ATTR = "@";
    private static final String EMPTY = "";

    public XPathContext() {
        this(null, null);
    }

    public XPathContext(Node root) {
        this(null, root);
    }

    public XPathContext(Map<String, String> prefix2uri) {
        this(prefix2uri, null);
    }

    public XPathContext(Map<String, String> prefix2uri, Node root) {
        this.uri2Prefix = prefix2uri == null ? Collections.emptyMap() : Collections.unmodifiableMap(XPathContext.invert(prefix2uri));
        this.path.addLast(new Level(EMPTY));
        if (root != null) {
            this.setChildren(Linqy.singleton(new DOMNodeInfo(root)));
            this.navigateToChild(0);
        }
    }

    public void navigateToChild(int index) {
        this.path.addLast((Level)this.path.getLast().children.get(index));
    }

    public void navigateToAttribute(QName attribute) {
        this.path.addLast((Level)this.path.getLast().attributes.get(attribute));
    }

    public void navigateToParent() {
        this.path.removeLast();
    }

    public void addAttributes(Iterable<? extends QName> attributes) {
        Level current = this.path.getLast();
        for (QName qName : attributes) {
            current.attributes.put(qName, new Level(ATTR + this.getName(qName)));
        }
    }

    public void addAttribute(QName attribute) {
        Level current = this.path.getLast();
        current.attributes.put(attribute, new Level(ATTR + this.getName(attribute)));
    }

    public void setChildren(Iterable<? extends NodeInfo> children) {
        Level current = this.path.getLast();
        current.children.clear();
        this.appendChildren(children);
    }

    public void appendChildren(Iterable<? extends NodeInfo> children) {
        Level current = this.path.getLast();
        int texts = 0;
        int pis = 0;
        int comments = 0;
        HashMap<String, Integer> elements = new HashMap<String, Integer>();
        for (Level level : current.children) {
            String childName = level.expression;
            if (childName.startsWith(COMMENT)) {
                ++comments;
                continue;
            }
            if (childName.startsWith(PI)) {
                ++pis;
                continue;
            }
            if (childName.startsWith(TEXT)) {
                ++texts;
                continue;
            }
            childName = childName.substring(0, childName.indexOf(OPEN));
            XPathContext.add1OrIncrement(childName, elements);
        }
        for (NodeInfo nodeInfo : children) {
            Level l;
            switch (nodeInfo.getType()) {
                case 8: {
                    l = new Level("comment()[" + ++comments + CLOSE);
                    break;
                }
                case 7: {
                    l = new Level("processing-instruction()[" + ++pis + CLOSE);
                    break;
                }
                case 3: 
                case 4: {
                    l = new Level("text()[" + ++texts + CLOSE);
                    break;
                }
                case 1: {
                    String name = this.getName(nodeInfo.getName());
                    l = new Level(name + OPEN + XPathContext.add1OrIncrement(name, elements) + CLOSE);
                    break;
                }
                default: {
                    l = new Level(EMPTY);
                }
            }
            current.children.add(l);
        }
    }

    public String getXPath() {
        return this.getXPath(this.path.descendingIterator());
    }

    public String getParentXPath() {
        Iterator<Level> levelIterator = this.path.descendingIterator();
        if (levelIterator.hasNext()) {
            levelIterator.next();
        }
        return this.getXPath(levelIterator);
    }

    public XPathContext clone() {
        try {
            XPathContext c = (XPathContext)super.clone();
            c.path = new LinkedList<Level>();
            for (Level l : this.path) {
                c.path.addLast(l.clone());
            }
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("XPathContext cannot be cloned?", e);
        }
    }

    private String getXPath(Iterator<Level> dIterator) {
        if (!dIterator.hasNext()) {
            return EMPTY;
        }
        Level l = dIterator.next();
        if (null == l.xpath) {
            String previous = this.getXPath(dIterator);
            if (!SEP.equals(previous)) {
                previous = previous + SEP;
            }
            l.xpath = previous + l.expression;
        }
        return l.xpath;
    }

    private String getName(QName name) {
        String ns = name.getNamespaceURI();
        String p = null;
        if (ns != null) {
            p = this.uri2Prefix.get(ns);
        }
        return (p == null ? EMPTY : p + ":") + name.getLocalPart();
    }

    private static int add1OrIncrement(String name, Map<String, Integer> map) {
        Integer old = map.get(name);
        int index = old == null ? 1 : old + 1;
        map.put(name, index);
        return index;
    }

    private static Map<String, String> invert(Map<String, String> m) {
        HashMap<String, String> inverted = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : m.entrySet()) {
            inverted.put(entry.getValue(), entry.getKey());
        }
        return inverted;
    }

    public static final class DOMNodeInfo
    implements NodeInfo {
        private final QName name;
        private final short type;

        public DOMNodeInfo(Node n) {
            this.name = Nodes.getQName(n);
            this.type = n.getNodeType();
        }

        @Override
        public QName getName() {
            return this.name;
        }

        @Override
        public short getType() {
            return this.type;
        }
    }

    public static interface NodeInfo {
        public QName getName();

        public short getType();
    }

    private static class Level
    implements Cloneable {
        private final String expression;
        private List<Level> children = new ArrayList<Level>();
        private Map<QName, Level> attributes = new HashMap<QName, Level>();
        private String xpath;

        private Level(String expression) {
            this.expression = expression;
        }

        public Level clone() {
            try {
                Level l = (Level)super.clone();
                l.children = new ArrayList<Level>(this.children.size());
                for (Level level : this.children) {
                    l.children.add(level.clone());
                }
                l.attributes = new HashMap<QName, Level>(this.attributes.size());
                for (Map.Entry entry : this.attributes.entrySet()) {
                    l.attributes.put((QName)entry.getKey(), ((Level)entry.getValue()).clone());
                }
                return l;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Level cannot be cloned?", e);
            }
        }
    }
}

