/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.handler;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import reactor.core.publisher.Mono;

public abstract class AbstractUrlHandlerMapping
extends AbstractHandlerMapping {
    private boolean lazyInitHandlers = false;
    private final Map<PathPattern, Object> handlerMap = new LinkedHashMap<PathPattern, Object>();

    public void setLazyInitHandlers(boolean lazyInitHandlers) {
        this.lazyInitHandlers = lazyInitHandlers;
    }

    public final Map<PathPattern, Object> getHandlerMap() {
        return Collections.unmodifiableMap(this.handlerMap);
    }

    public Mono<Object> getHandlerInternal(ServerWebExchange exchange2) {
        Object handler;
        PathContainer lookupPath = exchange2.getRequest().getPath().pathWithinApplication();
        try {
            handler = this.lookupHandler(lookupPath, exchange2);
        }
        catch (Exception ex) {
            return Mono.error(ex);
        }
        return Mono.justOrEmpty(handler);
    }

    @Nullable
    protected Object lookupHandler(PathContainer lookupPath, ServerWebExchange exchange2) throws Exception {
        List matches = this.handlerMap.keySet().stream().filter(key -> key.matches(lookupPath)).collect(Collectors.toList());
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() > 1) {
            matches.sort(PathPattern.SPECIFICITY_COMPARATOR);
            if (this.logger.isTraceEnabled()) {
                this.logger.debug(exchange2.getLogPrefix() + "Matching patterns " + matches);
            }
        }
        PathPattern pattern = (PathPattern)matches.get(0);
        PathContainer pathWithinMapping = pattern.extractPathWithinPattern(lookupPath);
        return this.handleMatch(this.handlerMap.get(pattern), pattern, pathWithinMapping, exchange2);
    }

    private Object handleMatch(Object handler, PathPattern bestMatch, PathContainer pathWithinMapping, ServerWebExchange exchange2) {
        if (handler instanceof String) {
            String handlerName = (String)handler;
            handler = this.obtainApplicationContext().getBean(handlerName);
        }
        this.validateHandler(handler, exchange2);
        exchange2.getAttributes().put(BEST_MATCHING_HANDLER_ATTRIBUTE, handler);
        exchange2.getAttributes().put(BEST_MATCHING_PATTERN_ATTRIBUTE, bestMatch);
        exchange2.getAttributes().put(PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, pathWithinMapping);
        return handler;
    }

    protected void validateHandler(Object handler, ServerWebExchange exchange2) {
    }

    protected void registerHandler(String[] urlPaths, String beanName) throws BeansException, IllegalStateException {
        Assert.notNull((Object)urlPaths, "URL path array must not be null");
        for (String urlPath : urlPaths) {
            this.registerHandler(urlPath, (Object)beanName);
        }
    }

    protected void registerHandler(String urlPath, Object handler) throws BeansException, IllegalStateException {
        Object existingHandler;
        Assert.notNull((Object)urlPath, "URL path must not be null");
        Assert.notNull(handler, "Handler object must not be null");
        Object resolvedHandler = handler;
        urlPath = AbstractUrlHandlerMapping.prependLeadingSlash(urlPath);
        PathPattern pattern = this.getPathPatternParser().parse(urlPath);
        if (this.handlerMap.containsKey(pattern) && (existingHandler = this.handlerMap.get(pattern)) != null && existingHandler != resolvedHandler) {
            throw new IllegalStateException("Cannot map " + this.getHandlerDescription(handler) + " to [" + urlPath + "]: there is already " + this.getHandlerDescription(existingHandler) + " mapped.");
        }
        if (!this.lazyInitHandlers && handler instanceof String) {
            String handlerName = (String)handler;
            if (this.obtainApplicationContext().isSingleton(handlerName)) {
                resolvedHandler = this.obtainApplicationContext().getBean(handlerName);
            }
        }
        this.handlerMap.put(pattern, resolvedHandler);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Mapped [" + urlPath + "] onto " + this.getHandlerDescription(handler));
        }
    }

    private String getHandlerDescription(Object handler) {
        return handler instanceof String ? "'" + handler + "'" : handler.toString();
    }

    private static String prependLeadingSlash(String pattern) {
        if (StringUtils.hasLength(pattern) && !pattern.startsWith("/")) {
            return "/" + pattern;
        }
        return pattern;
    }
}

