/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.runner.WorkloadParams;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.Optional;
import org.openjdk.jmh.util.lines.TestLineReader;
import org.openjdk.jmh.util.lines.TestLineWriter;

public class BenchmarkListEntry
implements Comparable<BenchmarkListEntry> {
    private final String userClassQName;
    private final String generatedClassQName;
    private final String method;
    private final Mode mode;
    private final int[] threadGroups;
    private final Optional<Collection<String>> threadGroupLabels;
    private final Optional<Integer> threads;
    private final Optional<Integer> warmupIterations;
    private final Optional<TimeValue> warmupTime;
    private final Optional<Integer> warmupBatchSize;
    private final Optional<Integer> measurementIterations;
    private final Optional<TimeValue> measurementTime;
    private final Optional<Integer> measurementBatchSize;
    private final Optional<Integer> forks;
    private final Optional<Integer> warmupForks;
    private final Optional<String> jvm;
    private final Optional<Collection<String>> jvmArgs;
    private final Optional<Collection<String>> jvmArgsPrepend;
    private final Optional<Collection<String>> jvmArgsAppend;
    private final Optional<Map<String, String[]>> params;
    private final Optional<TimeUnit> tu;
    private final Optional<Integer> opsPerInvocation;
    private final Optional<TimeValue> timeout;
    private WorkloadParams workloadParams;

    public BenchmarkListEntry(String userClassQName, String generatedClassQName, String method2, Mode mode, Optional<Integer> threads, int[] threadGroups, Optional<Collection<String>> threadGroupLabels, Optional<Integer> warmupIterations, Optional<TimeValue> warmupTime, Optional<Integer> warmupBatchSize, Optional<Integer> measurementIterations, Optional<TimeValue> measurementTime, Optional<Integer> measurementBatchSize, Optional<Integer> forks, Optional<Integer> warmupForks, Optional<String> jvm, Optional<Collection<String>> jvmArgs, Optional<Collection<String>> jvmArgsPrepend, Optional<Collection<String>> jvmArgsAppend, Optional<Map<String, String[]>> params, Optional<TimeUnit> tu, Optional<Integer> opsPerInv, Optional<TimeValue> timeout) {
        this.userClassQName = userClassQName;
        this.generatedClassQName = generatedClassQName;
        this.method = method2;
        this.mode = mode;
        this.threadGroups = threadGroups;
        this.threads = threads;
        this.threadGroupLabels = threadGroupLabels;
        this.warmupIterations = warmupIterations;
        this.warmupTime = warmupTime;
        this.warmupBatchSize = warmupBatchSize;
        this.measurementIterations = measurementIterations;
        this.measurementTime = measurementTime;
        this.measurementBatchSize = measurementBatchSize;
        this.forks = forks;
        this.warmupForks = warmupForks;
        this.jvm = jvm;
        this.jvmArgs = jvmArgs;
        this.jvmArgsPrepend = jvmArgsPrepend;
        this.jvmArgsAppend = jvmArgsAppend;
        this.params = params;
        this.workloadParams = new WorkloadParams();
        this.tu = tu;
        this.opsPerInvocation = opsPerInv;
        this.timeout = timeout;
    }

    public BenchmarkListEntry(String line) {
        this.workloadParams = new WorkloadParams();
        TestLineReader reader = new TestLineReader(line);
        if (!reader.isCorrect()) {
            throw new IllegalStateException("Unable to parse the line: " + line);
        }
        this.userClassQName = reader.nextString();
        this.generatedClassQName = reader.nextString();
        this.method = reader.nextString();
        this.mode = Mode.deepValueOf(reader.nextString());
        this.threads = reader.nextOptionalInt();
        this.threadGroups = reader.nextIntArray();
        this.threadGroupLabels = reader.nextOptionalStringCollection();
        this.warmupIterations = reader.nextOptionalInt();
        this.warmupTime = reader.nextOptionalTimeValue();
        this.warmupBatchSize = reader.nextOptionalInt();
        this.measurementIterations = reader.nextOptionalInt();
        this.measurementTime = reader.nextOptionalTimeValue();
        this.measurementBatchSize = reader.nextOptionalInt();
        this.forks = reader.nextOptionalInt();
        this.warmupForks = reader.nextOptionalInt();
        this.jvm = reader.nextOptionalString();
        this.jvmArgs = reader.nextOptionalStringCollection();
        this.jvmArgsPrepend = reader.nextOptionalStringCollection();
        this.jvmArgsAppend = reader.nextOptionalStringCollection();
        this.params = reader.nextOptionalParamCollection();
        this.tu = reader.nextOptionalTimeUnit();
        this.opsPerInvocation = reader.nextOptionalInt();
        this.timeout = reader.nextOptionalTimeValue();
    }

    public String toLine() {
        TestLineWriter writer = new TestLineWriter();
        writer.putString(this.userClassQName);
        writer.putString(this.generatedClassQName);
        writer.putString(this.method);
        writer.putString(this.mode.toString());
        writer.putOptionalInt(this.threads);
        writer.putIntArray(this.threadGroups);
        writer.putOptionalStringCollection(this.threadGroupLabels);
        writer.putOptionalInt(this.warmupIterations);
        writer.putOptionalTimeValue(this.warmupTime);
        writer.putOptionalInt(this.warmupBatchSize);
        writer.putOptionalInt(this.measurementIterations);
        writer.putOptionalTimeValue(this.measurementTime);
        writer.putOptionalInt(this.measurementBatchSize);
        writer.putOptionalInt(this.forks);
        writer.putOptionalInt(this.warmupForks);
        writer.putOptionalString(this.jvm);
        writer.putOptionalStringCollection(this.jvmArgs);
        writer.putOptionalStringCollection(this.jvmArgsPrepend);
        writer.putOptionalStringCollection(this.jvmArgsAppend);
        writer.putOptionalParamCollection(this.params);
        writer.putOptionalTimeUnit(this.tu);
        writer.putOptionalInt(this.opsPerInvocation);
        writer.putOptionalTimeValue(this.timeout);
        return writer.toString();
    }

    public BenchmarkListEntry cloneWith(Mode mode) {
        return new BenchmarkListEntry(this.userClassQName, this.generatedClassQName, this.method, mode, this.threads, this.threadGroups, this.threadGroupLabels, this.warmupIterations, this.warmupTime, this.warmupBatchSize, this.measurementIterations, this.measurementTime, this.measurementBatchSize, this.forks, this.warmupForks, this.jvm, this.jvmArgs, this.jvmArgsPrepend, this.jvmArgsAppend, this.params, this.tu, this.opsPerInvocation, this.timeout);
    }

    public BenchmarkListEntry cloneWith(WorkloadParams p) {
        BenchmarkListEntry br = new BenchmarkListEntry(this.userClassQName, this.generatedClassQName, this.method, this.mode, this.threads, this.threadGroups, this.threadGroupLabels, this.warmupIterations, this.warmupTime, this.warmupBatchSize, this.measurementIterations, this.measurementTime, this.measurementBatchSize, this.forks, this.warmupForks, this.jvm, this.jvmArgs, this.jvmArgsPrepend, this.jvmArgsAppend, this.params, this.tu, this.opsPerInvocation, this.timeout);
        br.workloadParams = p;
        return br;
    }

    public WorkloadParams getWorkloadParams() {
        return this.workloadParams;
    }

    @Override
    public int compareTo(BenchmarkListEntry o) {
        int v = this.mode.compareTo(o.mode);
        if (v != 0) {
            return v;
        }
        int v1 = this.getUsername().compareTo(o.getUsername());
        if (v1 != 0) {
            return v1;
        }
        if (this.workloadParams == null || o.workloadParams == null) {
            return 0;
        }
        return this.workloadParams.compareTo(o.workloadParams);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BenchmarkListEntry record = (BenchmarkListEntry)o;
        if (this.mode != record.mode) {
            return false;
        }
        if (this.workloadParams != null ? !this.workloadParams.equals(record.workloadParams) : record.workloadParams != null) {
            return false;
        }
        if (this.userClassQName != null ? !this.userClassQName.equals(record.userClassQName) : record.userClassQName != null) {
            return false;
        }
        return !(this.method != null ? !this.method.equals(record.method) : record.method != null);
    }

    public int hashCode() {
        int result = this.userClassQName != null ? this.userClassQName.hashCode() : 0;
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
        result = 31 * result + (this.workloadParams != null ? this.workloadParams.hashCode() : 0);
        return result;
    }

    public String generatedTarget() {
        return this.generatedClassQName + "." + this.method + "_" + (Object)((Object)this.mode);
    }

    public String getUsername() {
        return this.userClassQName + "." + this.method;
    }

    public String getUserClassQName() {
        return this.userClassQName;
    }

    public Mode getMode() {
        return this.mode;
    }

    public int[] getThreadGroups() {
        return Arrays.copyOf(this.threadGroups, this.threadGroups.length);
    }

    public Optional<Collection<String>> getThreadGroupLabels() {
        return this.threadGroupLabels;
    }

    public String toString() {
        return "{'" + this.userClassQName + "." + this.method + "', " + (Object)((Object)this.mode) + ", " + this.workloadParams + "}";
    }

    public Optional<TimeValue> getWarmupTime() {
        return this.warmupTime;
    }

    public Optional<Integer> getWarmupIterations() {
        return this.warmupIterations;
    }

    public Optional<Integer> getWarmupBatchSize() {
        return this.warmupBatchSize;
    }

    public Optional<TimeValue> getMeasurementTime() {
        return this.measurementTime;
    }

    public Optional<Integer> getMeasurementIterations() {
        return this.measurementIterations;
    }

    public Optional<Integer> getMeasurementBatchSize() {
        return this.measurementBatchSize;
    }

    public Optional<Integer> getForks() {
        return this.forks;
    }

    public Optional<Integer> getWarmupForks() {
        return this.warmupForks;
    }

    public Optional<String> getJvm() {
        return this.jvm;
    }

    public Optional<Collection<String>> getJvmArgs() {
        return this.jvmArgs;
    }

    public Optional<Collection<String>> getJvmArgsAppend() {
        return this.jvmArgsAppend;
    }

    public Optional<Collection<String>> getJvmArgsPrepend() {
        return this.jvmArgsPrepend;
    }

    public Optional<Integer> getThreads() {
        return this.threads;
    }

    public Optional<Map<String, String[]>> getParams() {
        return this.params;
    }

    public Optional<TimeUnit> getTimeUnit() {
        return this.tu;
    }

    public Optional<Integer> getOperationsPerInvocation() {
        return this.opsPerInvocation;
    }

    public Optional<TimeValue> getTimeout() {
        return this.timeout;
    }
}

