/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.Control;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.infra.ThreadParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.ProfilerFactory;
import org.openjdk.jmh.results.BenchmarkTaskResult;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.IterationResultMetaData;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.FailureAssistException;
import org.openjdk.jmh.runner.InfraControl;
import org.openjdk.jmh.runner.WorkerThreadFactory;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.ClassUtils;
import org.openjdk.jmh.util.Utils;

class BenchmarkHandler {
    private final ExecutorService executor;
    private final ThreadLocal<ThreadData> threadData;
    private final OutputFormat out;
    private final List<InternalProfiler> profilers;
    private final List<InternalProfiler> profilersRev;
    private final Method method;
    private static final ExecutorType EXECUTOR_TYPE = Enum.valueOf(ExecutorType.class, System.getProperty("jmh.executor", ExecutorType.FIXED_TPE.name()));

    public BenchmarkHandler(OutputFormat out, Options options, BenchmarkParams executionParams) {
        String target = executionParams.generatedBenchmark();
        int lastDot = target.lastIndexOf(46);
        final Class<?> clazz = ClassUtils.loadClass(target.substring(0, lastDot));
        this.method = BenchmarkHandler.findBenchmarkMethod(clazz, target.substring(lastDot + 1));
        this.profilers = ProfilerFactory.getSupportedInternal(options.getProfilers());
        this.profilersRev = new ArrayList<InternalProfiler>(this.profilers);
        Collections.reverse(this.profilersRev);
        final ArrayBlockingQueue<ThreadParams> tps = new ArrayBlockingQueue<ThreadParams>(executionParams.getThreads());
        tps.addAll(BenchmarkHandler.distributeThreads(executionParams.getThreads(), executionParams.getThreadGroups()));
        this.threadData = new ThreadLocal<ThreadData>(){

            @Override
            protected ThreadData initialValue() {
                try {
                    Object o = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    ThreadParams t = (ThreadParams)tps.poll();
                    if (t == null) {
                        throw new IllegalStateException("Cannot get another thread params");
                    }
                    return new ThreadData(o, t);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("Class " + clazz.getName() + " instantiation error ", e);
                }
            }
        };
        this.out = out;
        try {
            this.executor = EXECUTOR_TYPE.createExecutor(executionParams.getThreads(), executionParams.getBenchmark());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static List<ThreadParams> distributeThreads(int threads, int[] groups) {
        ArrayList<ThreadParams> result = new ArrayList<ThreadParams>();
        int totalGroupThreads = Utils.sum(groups);
        int totalGroups = (int)Math.ceil(1.0 * (double)threads / (double)totalGroupThreads);
        int totalSubgroups = groups.length;
        int currentGroupThread = 0;
        int currentSubgroupThread = 0;
        int currentGroup = 0;
        int currentSubgroup = 0;
        for (int t = 0; t < threads; ++t) {
            while (currentSubgroupThread >= groups[currentSubgroup]) {
                if (++currentSubgroup == groups.length) {
                    ++currentGroup;
                    currentSubgroup = 0;
                    currentGroupThread = 0;
                }
                currentSubgroupThread = 0;
            }
            result.add(new ThreadParams(t, threads, currentGroup, totalGroups, currentSubgroup, totalSubgroups, currentGroupThread, totalGroupThreads, currentSubgroupThread, groups[currentSubgroup]));
            ++currentGroupThread;
            ++currentSubgroupThread;
        }
        return result;
    }

    public static Method findBenchmarkMethod(Class<?> clazz, String methodName) {
        Method method2 = null;
        for (Method m : ClassUtils.enumerateMethods(clazz)) {
            if (!m.getName().equals(methodName)) continue;
            if (BenchmarkHandler.isValidBenchmarkSignature(m)) {
                if (method2 != null) {
                    throw new IllegalArgumentException("Ambiguous methods: \n" + method2 + "\n and \n" + m + "\n, which one to execute?");
                }
                method2 = m;
                continue;
            }
            throw new IllegalArgumentException("Benchmark parameters do not match the signature contract.");
        }
        if (method2 == null) {
            throw new IllegalArgumentException("No matching methods found in benchmark");
        }
        return method2;
    }

    private static boolean isValidBenchmarkSignature(Method m) {
        if (m.getReturnType() != BenchmarkTaskResult.class) {
            return false;
        }
        Class<?>[] parameterTypes = m.getParameterTypes();
        if (parameterTypes.length != 2) {
            return false;
        }
        if (parameterTypes[0] != InfraControl.class) {
            return false;
        }
        return parameterTypes[1] == ThreadParams.class;
    }

    protected void startProfilers(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        for (InternalProfiler prof : this.profilers) {
            try {
                prof.beforeIteration(benchmarkParams, iterationParams);
            }
            catch (Throwable ex) {
                throw new BenchmarkException(ex);
            }
        }
    }

    protected void stopProfilers(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult iterationResults) {
        for (InternalProfiler prof : this.profilersRev) {
            try {
                iterationResults.addResults(prof.afterIteration(benchmarkParams, iterationParams, iterationResults));
            }
            catch (Throwable ex) {
                throw new BenchmarkException(ex);
            }
        }
    }

    public void shutdown() {
        if (EXECUTOR_TYPE.shutdownForbidden() || this.executor == null) {
            return;
        }
        while (true) {
            this.executor.shutdown();
            try {
                if (this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    return;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            this.out.println("Failed to stop executor service " + this.executor + ", trying again; check for the unaccounted running threads");
        }
    }

    public IterationResult runIteration(BenchmarkParams benchmarkParams, IterationParams params, boolean last) {
        int numThreads = benchmarkParams.getThreads();
        TimeValue runtime = params.getTime();
        CountDownLatch preSetupBarrier = new CountDownLatch(numThreads);
        CountDownLatch preTearDownBarrier = new CountDownLatch(numThreads);
        ArrayList<Result> iterationResults = new ArrayList<Result>();
        InfraControl control = new InfraControl(benchmarkParams, params, preSetupBarrier, preTearDownBarrier, last, new Control());
        BenchmarkTask[] runners = new BenchmarkTask[numThreads];
        for (int i = 0; i < runners.length; ++i) {
            runners[i] = new BenchmarkTask(control);
        }
        long waitDeadline = System.nanoTime() + benchmarkParams.getTimeout().convertTo(TimeUnit.NANOSECONDS);
        this.startProfilers(benchmarkParams, params);
        ArrayList completed = new ArrayList();
        ExecutorCompletionService<BenchmarkTaskResult> srv = new ExecutorCompletionService<BenchmarkTaskResult>(this.executor);
        for (BenchmarkTask runner : runners) {
            srv.submit(runner);
        }
        control.awaitWarmupReady();
        switch (benchmarkParams.getMode()) {
            case SingleShotTime: {
                break;
            }
            default: {
                try {
                    Future failing = srv.poll(runtime.convertTo(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
                    if (failing == null) break;
                    completed.add(failing);
                    waitDeadline = System.nanoTime();
                    break;
                }
                catch (InterruptedException failing) {
                    // empty catch block
                }
            }
        }
        control.announceDone();
        control.awaitWarmdownReady();
        while (completed.size() < numThreads) {
            try {
                long waitFor = Math.max(TimeUnit.MILLISECONDS.toNanos(100L), waitDeadline - System.nanoTime());
                Future fr = srv.poll(waitFor, TimeUnit.NANOSECONDS);
                if (fr == null) {
                    this.out.print("(*interrupt*) ");
                    for (BenchmarkTask benchmarkTask : runners) {
                        Thread runner = benchmarkTask.runner;
                        if (runner == null) continue;
                        runner.interrupt();
                    }
                    continue;
                }
                completed.add(fr);
            }
            catch (InterruptedException ex) {
                throw new BenchmarkException(ex);
            }
        }
        long allOps = 0L;
        long measuredOps = 0L;
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (Future future : completed) {
            try {
                BenchmarkTaskResult btr = (BenchmarkTaskResult)future.get();
                iterationResults.addAll(btr.getResults());
                allOps += btr.getAllOps();
                measuredOps += btr.getMeasuredOps();
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause().getCause().getCause();
                if (cause instanceof FailureAssistException) continue;
                errors.add(cause);
            }
            catch (InterruptedException ex) {
                throw new BenchmarkException(ex);
            }
        }
        IterationResult result = new IterationResult(benchmarkParams, params, new IterationResultMetaData(allOps, measuredOps));
        result.addResults(iterationResults);
        this.stopProfilers(benchmarkParams, params, result);
        if (!errors.isEmpty()) {
            throw new BenchmarkException("Benchmark error during the run", errors);
        }
        return result;
    }

    private static class ThreadData {
        final Object instance;
        final ThreadParams params;

        public ThreadData(Object instance, ThreadParams params) {
            this.instance = instance;
            this.params = params;
        }
    }

    class BenchmarkTask
    implements Callable<BenchmarkTaskResult> {
        private volatile Thread runner;
        private final InfraControl control;

        BenchmarkTask(InfraControl control) {
            this.control = control;
        }

        @Override
        public BenchmarkTaskResult call() throws Exception {
            try {
                this.runner = Thread.currentThread();
                ThreadData td = (ThreadData)BenchmarkHandler.this.threadData.get();
                BenchmarkTaskResult benchmarkTaskResult = (BenchmarkTaskResult)BenchmarkHandler.this.method.invoke(td.instance, this.control, td.params);
                return benchmarkTaskResult;
            }
            catch (Throwable e) {
                this.control.isFailing = true;
                this.control.preSetupForce();
                this.control.preTearDownForce();
                if (this.control.benchmarkParams.shouldSynchIterations()) {
                    try {
                        this.control.announceWarmupReady();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.control.announceWarmdownReady();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new Exception(e);
            }
            finally {
                this.runner = null;
            }
        }
    }

    private static enum ExecutorType {
        CACHED_TPE{

            @Override
            ExecutorService createExecutor(int maxThreads, String prefix) {
                return Executors.newCachedThreadPool(new WorkerThreadFactory(prefix));
            }
        }
        ,
        FIXED_TPE{

            @Override
            ExecutorService createExecutor(int maxThreads, String prefix) {
                return Executors.newFixedThreadPool(maxThreads, new WorkerThreadFactory(prefix));
            }
        }
        ,
        FJP{

            @Override
            ExecutorService createExecutor(int maxThreads, String prefix) throws Exception {
                return new ForkJoinPool(maxThreads);
            }
        }
        ,
        FJP_COMMON{

            @Override
            ExecutorService createExecutor(int maxThreads, String prefix) throws Exception {
                Method m = Class.forName("java.util.concurrent.ForkJoinPool").getMethod("commonPool", new Class[0]);
                return (ExecutorService)m.invoke(null, new Object[0]);
            }

            @Override
            boolean shutdownForbidden() {
                return true;
            }
        }
        ,
        CUSTOM{

            @Override
            ExecutorService createExecutor(int maxThreads, String prefix) throws Exception {
                String className = System.getProperty("jmh.executor.class");
                return (ExecutorService)Class.forName(className).getConstructor(Integer.TYPE, String.class).newInstance(maxThreads, prefix);
            }
        };


        abstract ExecutorService createExecutor(int var1, String var2) throws Exception;

        boolean shutdownForbidden() {
            return false;
        }
    }
}

