/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.AggregatorUtils;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.ListStatistics;
import org.openjdk.jmh.util.Statistics;

public class SingleShotResult
extends Result<SingleShotResult> {
    private static final long serialVersionUID = -1251578870918524737L;

    public SingleShotResult(ResultRole role, String label, long duration, TimeUnit outputTimeUnit) {
        this(role, label, SingleShotResult.of(1.0 * (double)duration / (double)TimeUnit.NANOSECONDS.convert(1L, outputTimeUnit)), TimeValue.tuToString(outputTimeUnit) + "/op");
    }

    SingleShotResult(ResultRole mode, String label, Statistics s, String unit) {
        super(mode, label, s, unit, AggregationPolicy.AVG);
    }

    @Override
    public String extendedInfo() {
        return this.distributionExtendedInfo();
    }

    @Override
    protected Aggregator<SingleShotResult> getThreadAggregator() {
        return new AveragingAggregator();
    }

    @Override
    protected Aggregator<SingleShotResult> getIterationAggregator() {
        return new AveragingAggregator();
    }

    static class AveragingAggregator
    implements Aggregator<SingleShotResult> {
        AveragingAggregator() {
        }

        @Override
        public SingleShotResult aggregate(Collection<SingleShotResult> results) {
            ListStatistics stat = new ListStatistics();
            for (SingleShotResult r : results) {
                stat.addValue(r.getScore());
            }
            return new SingleShotResult(AggregatorUtils.aggregateRoles(results), AggregatorUtils.aggregateLabels(results), stat, AggregatorUtils.aggregateUnits(results));
        }
    }
}

