/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.eclipse.jetty.client.AsyncContentProvider;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.util.DeferredContentProvider;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.util.Callback;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class PublisherContentProvider
implements ContentProvider.Typed,
AsyncContentProvider,
Subscriber<ContentChunk> {
    private final DeferredContentProvider provider = new DeferredContentProvider(new ByteBuffer[0]);
    private final ReactiveRequest.Content content;
    private Subscription subscription;

    public PublisherContentProvider(ReactiveRequest.Content content) {
        this.content = content;
        content.subscribe(this);
    }

    @Override
    public long getLength() {
        return this.content.getLength();
    }

    @Override
    public String getContentType() {
        return this.content.getContentType();
    }

    @Override
    public void setListener(AsyncContentProvider.Listener listener) {
        this.provider.setListener(listener);
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return this.provider.iterator();
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    @Override
    public void onNext(ContentChunk chunk) {
        this.provider.offer(chunk.buffer, new Callback.Nested(chunk.callback){

            @Override
            public void succeeded() {
                super.succeeded();
                PublisherContentProvider.this.subscription.request(1L);
            }

            @Override
            public void failed(Throwable x) {
                super.failed(x);
                PublisherContentProvider.this.subscription.cancel();
            }
        });
    }

    @Override
    public void onError(Throwable failure) {
        this.provider.failed(failure);
    }

    @Override
    public void onComplete() {
        this.provider.close();
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

