/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.eclipse.jetty.client.AsyncContentProvider;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.RequestNotifier;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class HttpSender
implements AsyncContentProvider.Listener {
    protected static final Logger LOG = Log.getLogger(HttpSender.class);
    private final AtomicReference<RequestState> requestState = new AtomicReference<RequestState>(RequestState.QUEUED);
    private final AtomicReference<SenderState> senderState = new AtomicReference<SenderState>(SenderState.IDLE);
    private final Callback commitCallback = new CommitCallback();
    private final IteratingCallback contentCallback = new ContentCallback();
    private final Callback trailersCallback = new TrailersCallback();
    private final Callback lastCallback = new LastCallback();
    private final HttpChannel channel;
    private HttpContent content;
    private Throwable failure;

    protected HttpSender(HttpChannel channel) {
        this.channel = channel;
    }

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    public boolean isFailed() {
        return this.requestState.get() == RequestState.FAILURE;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onContent() {
        exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        block7: while (true) {
            current = this.senderState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$client$HttpSender$SenderState[current.ordinal()]) {
                case 1: {
                    newSenderState = SenderState.SENDING;
                    if (!this.updateSenderState(current, newSenderState)) continue block7;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    }
                    this.contentCallback.iterate();
                    return;
                }
                case 2: {
                    newSenderState = SenderState.SENDING_WITH_CONTENT;
                    if (!this.updateSenderState(current, newSenderState)) continue block7;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    }
                    return;
                }
                case 3: {
                    newSenderState = SenderState.EXPECTING_WITH_CONTENT;
                    if (!this.updateSenderState(current, newSenderState)) continue block7;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    }
                    return;
                }
                case 4: {
                    newSenderState = SenderState.PROCEEDING_WITH_CONTENT;
                    if (this.updateSenderState(current, newSenderState)) ** break;
                    continue block7;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    }
                    return;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {}", new Object[]{current});
                    }
                    return;
                }
            }
            break;
        }
        this.illegalSenderState(current);
    }

    public void send(HttpExchange exchange2) {
        if (!this.queuedToBegin(exchange2)) {
            return;
        }
        HttpRequest request = exchange2.getRequest();
        ContentProvider contentProvider = request.getContent();
        HttpContent content = this.content = new HttpContent(contentProvider);
        SenderState newSenderState = SenderState.SENDING;
        if (this.expects100Continue(request)) {
            newSenderState = content.hasContent() ? SenderState.EXPECTING_WITH_CONTENT : SenderState.EXPECTING;
        }
        block3: while (true) {
            SenderState current = this.senderState.get();
            switch (current) {
                case IDLE: 
                case COMPLETED: {
                    if (!this.updateSenderState(current, newSenderState)) continue block3;
                    break block3;
                }
                default: {
                    this.illegalSenderState(current);
                    return;
                }
            }
            break;
        }
        if (contentProvider instanceof AsyncContentProvider) {
            ((AsyncContentProvider)contentProvider).setListener(this);
        }
        if (!this.beginToHeaders(exchange2)) {
            return;
        }
        this.sendHeaders(exchange2, content, this.commitCallback);
    }

    protected boolean expects100Continue(Request request) {
        return request.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
    }

    protected boolean queuedToBegin(HttpExchange exchange2) {
        if (!this.updateRequestState(RequestState.QUEUED, RequestState.TRANSIENT)) {
            return false;
        }
        HttpRequest request = exchange2.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request begin {}", request);
        }
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyBegin(request);
        if (this.updateRequestState(RequestState.TRANSIENT, RequestState.BEGIN)) {
            return true;
        }
        this.terminateRequest(exchange2);
        return false;
    }

    protected boolean beginToHeaders(HttpExchange exchange2) {
        if (!this.updateRequestState(RequestState.BEGIN, RequestState.TRANSIENT)) {
            return false;
        }
        HttpRequest request = exchange2.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request headers {}{}{}", request, System.lineSeparator(), request.getHeaders().toString().trim());
        }
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyHeaders(request);
        if (this.updateRequestState(RequestState.TRANSIENT, RequestState.HEADERS)) {
            return true;
        }
        this.terminateRequest(exchange2);
        return false;
    }

    protected boolean headersToCommit(HttpExchange exchange2) {
        if (!this.updateRequestState(RequestState.HEADERS, RequestState.TRANSIENT)) {
            return false;
        }
        HttpRequest request = exchange2.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request committed {}", request);
        }
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyCommit(request);
        if (this.updateRequestState(RequestState.TRANSIENT, RequestState.COMMIT)) {
            return true;
        }
        this.terminateRequest(exchange2);
        return false;
    }

    protected boolean someToContent(HttpExchange exchange2, ByteBuffer content) {
        RequestState current = this.requestState.get();
        switch (current) {
            case COMMIT: 
            case CONTENT: {
                if (!this.updateRequestState(current, RequestState.TRANSIENT)) {
                    return false;
                }
                HttpRequest request = exchange2.getRequest();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request content {}{}{}", request, System.lineSeparator(), BufferUtil.toDetailString(content));
                }
                RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
                notifier.notifyContent(request, content);
                if (this.updateRequestState(RequestState.TRANSIENT, RequestState.CONTENT)) {
                    return true;
                }
                this.terminateRequest(exchange2);
                return false;
            }
        }
        return false;
    }

    protected boolean someToSuccess(HttpExchange exchange2) {
        RequestState current = this.requestState.get();
        switch (current) {
            case COMMIT: 
            case CONTENT: {
                if (!exchange2.requestComplete(null)) {
                    return false;
                }
                this.requestState.set(RequestState.QUEUED);
                this.reset();
                HttpRequest request = exchange2.getRequest();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request success {}", request);
                }
                HttpDestination destination = this.getHttpChannel().getHttpDestination();
                destination.getRequestNotifier().notifySuccess(exchange2.getRequest());
                Result result = exchange2.terminateRequest();
                this.terminateRequest(exchange2, null, result);
                return true;
            }
        }
        return false;
    }

    private void anyToFailure(Throwable failure) {
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 == null) {
            return;
        }
        if (exchange2.requestComplete(failure)) {
            this.executeAbort(exchange2, failure);
        }
    }

    private void executeAbort(HttpExchange exchange2, Throwable failure) {
        try {
            Executor executor = this.getHttpChannel().getHttpDestination().getHttpClient().getExecutor();
            executor.execute(() -> this.abort(exchange2, failure));
        }
        catch (RejectedExecutionException x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            this.abort(exchange2, failure);
        }
    }

    private void terminateRequest(HttpExchange exchange2) {
        Throwable failure = this.failure;
        if (failure == null) {
            failure = new HttpRequestException("Concurrent failure", exchange2.getRequest());
        }
        Result result = exchange2.terminateRequest();
        this.terminateRequest(exchange2, failure, result);
    }

    private void terminateRequest(HttpExchange exchange2, Throwable failure, Result result) {
        HttpRequest request = exchange2.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminating request {}", request);
        }
        if (result == null) {
            if (failure != null && exchange2.responseComplete(failure)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response failure from request {} {}", request, exchange2);
                }
                this.getHttpChannel().abortResponse(exchange2, failure);
            }
        } else {
            result = this.channel.exchangeTerminating(exchange2, result);
            HttpDestination destination = this.getHttpChannel().getHttpDestination();
            boolean ordered = destination.getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(exchange2, result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request/Response {}: {}", failure == null ? "succeeded" : "failed", result);
            }
            HttpConversation conversation = exchange2.getConversation();
            destination.getResponseNotifier().notifyComplete(conversation.getResponseListeners(), result);
            if (ordered) {
                this.channel.exchangeTerminated(exchange2, result);
            }
        }
    }

    protected abstract void sendHeaders(HttpExchange var1, HttpContent var2, Callback var3);

    protected abstract void sendContent(HttpExchange var1, HttpContent var2, Callback var3);

    protected abstract void sendTrailers(HttpExchange var1, Callback var2);

    protected void reset() {
        HttpContent content = this.content;
        this.content = null;
        content.close();
        this.senderState.set(SenderState.COMPLETED);
    }

    protected void dispose() {
        HttpContent content = this.content;
        this.content = null;
        if (content != null) {
            content.close();
        }
        this.senderState.set(SenderState.FAILED);
    }

    /*
     * Unable to fully structure code
     */
    public void proceed(HttpExchange exchange, Throwable failure) {
        if (!this.expects100Continue(exchange.getRequest())) {
            return;
        }
        if (failure != null) {
            this.anyToFailure(failure);
            return;
        }
        block6: while (true) {
            current = this.senderState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$client$HttpSender$SenderState[current.ordinal()]) {
                case 3: {
                    if (!this.updateSenderState(current, SenderState.PROCEEDING)) continue block6;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Proceeding while expecting", new Object[0]);
                    }
                    return;
                }
                case 6: {
                    if (!this.updateSenderState(current, SenderState.PROCEEDING_WITH_CONTENT)) continue block6;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Proceeding while scheduled", new Object[0]);
                    }
                    return;
                }
                case 8: {
                    if (this.updateSenderState(current, SenderState.SENDING)) ** break;
                    continue block6;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Proceeding while waiting", new Object[0]);
                    }
                    this.contentCallback.iterate();
                    return;
                }
                case 10: {
                    return;
                }
            }
            break;
        }
        this.illegalSenderState(current);
    }

    public boolean abort(HttpExchange exchange2, Throwable failure) {
        RequestState current;
        do {
            current = this.requestState.get();
            switch (current) {
                case FAILURE: {
                    return false;
                }
            }
        } while (!this.updateRequestState(current, RequestState.FAILURE));
        boolean terminate = current != RequestState.TRANSIENT;
        this.failure = failure;
        this.dispose();
        HttpRequest request = exchange2.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request failure {} {} on {}: {}", request, exchange2, this.getHttpChannel(), failure);
        }
        HttpDestination destination = this.getHttpChannel().getHttpDestination();
        destination.getRequestNotifier().notifyFailure(request, failure);
        if (terminate) {
            Result result = exchange2.terminateRequest();
            this.terminateRequest(exchange2, failure, result);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Concurrent failure: request termination skipped, performed by helpers", new Object[0]);
        }
        return false;
    }

    private boolean updateRequestState(RequestState from, RequestState to) {
        boolean updated = this.requestState.compareAndSet(from, to);
        if (!updated && LOG.isDebugEnabled()) {
            LOG.debug("RequestState update failed: {} -> {}: {}", new Object[]{from, to, this.requestState.get()});
        }
        return updated;
    }

    private boolean updateSenderState(SenderState from, SenderState to) {
        boolean updated = this.senderState.compareAndSet(from, to);
        if (!updated && LOG.isDebugEnabled()) {
            LOG.debug("SenderState update failed: {} -> {}: {}", new Object[]{from, to, this.senderState.get()});
        }
        return updated;
    }

    private void illegalSenderState(SenderState current) {
        this.anyToFailure(new IllegalStateException("Expected " + (Object)((Object)current) + " found " + (Object)((Object)this.senderState.get()) + " instead"));
    }

    public String toString() {
        return String.format("%s@%x(req=%s,snd=%s,failure=%s)", this.getClass().getSimpleName(), this.hashCode(), this.requestState, this.senderState, this.failure);
    }

    private class LastCallback
    implements Callback {
        private LastCallback() {
        }

        @Override
        public void succeeded() {
            HttpExchange exchange2 = HttpSender.this.getHttpExchange();
            if (exchange2 == null) {
                return;
            }
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            content.succeeded();
            HttpSender.this.someToSuccess(exchange2);
        }

        @Override
        public void failed(Throwable failure) {
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            content.failed(failure);
            HttpSender.this.anyToFailure(failure);
        }
    }

    private class TrailersCallback
    implements Callback {
        private TrailersCallback() {
        }

        @Override
        public void succeeded() {
            HttpExchange exchange2 = HttpSender.this.getHttpExchange();
            if (exchange2 == null) {
                return;
            }
            HttpSender.this.sendTrailers(exchange2, HttpSender.this.lastCallback);
        }

        @Override
        public void failed(Throwable x) {
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            content.failed(x);
            HttpSender.this.anyToFailure(x);
        }
    }

    private class ContentCallback
    extends IteratingCallback {
        private ContentCallback() {
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            SenderState current;
            HttpExchange exchange2 = HttpSender.this.getHttpExchange();
            if (exchange2 == null) {
                return IteratingCallback.Action.IDLE;
            }
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return IteratingCallback.Action.IDLE;
            }
            block4: while (true) {
                boolean advanced = content.advance();
                boolean lastContent = content.isLast();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content present {}, last {}, consumed {} for {}", advanced, lastContent, content.isConsumed(), exchange2.getRequest());
                }
                if (advanced) {
                    HttpSender.this.sendContent(exchange2, content, this);
                    return IteratingCallback.Action.SCHEDULED;
                }
                if (lastContent) {
                    HttpRequest request = exchange2.getRequest();
                    Supplier<HttpFields> trailers = request.getTrailers();
                    HttpSender.this.sendContent(exchange2, content, trailers == null ? HttpSender.this.lastCallback : HttpSender.this.trailersCallback);
                    return IteratingCallback.Action.IDLE;
                }
                current = (SenderState)((Object)HttpSender.this.senderState.get());
                switch (current) {
                    case SENDING: {
                        if (!HttpSender.this.updateSenderState(current, SenderState.IDLE)) continue block4;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Content is deferred for {}", exchange2.getRequest());
                        }
                        return IteratingCallback.Action.IDLE;
                    }
                    case SENDING_WITH_CONTENT: {
                        HttpSender.this.updateSenderState(current, SenderState.SENDING);
                        continue block4;
                    }
                }
                break;
            }
            HttpSender.this.illegalSenderState(current);
            return IteratingCallback.Action.IDLE;
        }

        @Override
        public void succeeded() {
            HttpExchange exchange2 = HttpSender.this.getHttpExchange();
            if (exchange2 == null) {
                return;
            }
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            content.succeeded();
            ByteBuffer buffer = content.getContent();
            HttpSender.this.someToContent(exchange2, buffer);
            super.succeeded();
        }

        @Override
        public void onCompleteFailure(Throwable failure) {
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            content.failed(failure);
            HttpSender.this.anyToFailure(failure);
        }

        @Override
        protected void onCompleteSuccess() {
        }
    }

    private class CommitCallback
    implements Callback {
        private CommitCallback() {
        }

        @Override
        public void succeeded() {
            try {
                HttpContent content = HttpSender.this.content;
                if (content == null) {
                    return;
                }
                content.succeeded();
                this.process();
            }
            catch (Throwable x) {
                HttpSender.this.anyToFailure(x);
            }
        }

        @Override
        public void failed(Throwable failure) {
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            content.failed(failure);
            HttpSender.this.anyToFailure(failure);
        }

        private void process() throws Exception {
            HttpExchange exchange2 = HttpSender.this.getHttpExchange();
            if (exchange2 == null) {
                return;
            }
            if (!HttpSender.this.headersToCommit(exchange2)) {
                return;
            }
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            HttpRequest request = exchange2.getRequest();
            Supplier<HttpFields> trailers = request.getTrailers();
            boolean hasContent = content.hasContent();
            if (!hasContent) {
                if (trailers == null) {
                    HttpSender.this.someToSuccess(exchange2);
                } else {
                    HttpSender.this.sendTrailers(exchange2, HttpSender.this.lastCallback);
                }
            } else {
                SenderState current;
                ByteBuffer contentBuffer = content.getContent();
                if (contentBuffer != null && !HttpSender.this.someToContent(exchange2, contentBuffer)) {
                    return;
                }
                block9: while (true) {
                    current = (SenderState)((Object)HttpSender.this.senderState.get());
                    switch (current) {
                        case SENDING: {
                            HttpSender.this.contentCallback.iterate();
                            return;
                        }
                        case SENDING_WITH_CONTENT: {
                            HttpSender.this.updateSenderState(current, SenderState.SENDING);
                            continue block9;
                        }
                        case EXPECTING: {
                            if (!HttpSender.this.updateSenderState(current, SenderState.WAITING)) continue block9;
                            return;
                        }
                        case EXPECTING_WITH_CONTENT: {
                            if (!HttpSender.this.updateSenderState(current, SenderState.WAITING)) continue block9;
                            return;
                        }
                        case PROCEEDING: {
                            if (!HttpSender.this.updateSenderState(current, SenderState.IDLE)) continue block9;
                            return;
                        }
                        case PROCEEDING_WITH_CONTENT: {
                            HttpSender.this.updateSenderState(current, SenderState.SENDING);
                            continue block9;
                        }
                        case FAILED: {
                            return;
                        }
                    }
                    break;
                }
                HttpSender.this.illegalSenderState(current);
                return;
            }
        }
    }

    private static enum SenderState {
        IDLE,
        SENDING,
        SENDING_WITH_CONTENT,
        EXPECTING,
        EXPECTING_WITH_CONTENT,
        WAITING,
        PROCEEDING,
        PROCEEDING_WITH_CONTENT,
        COMPLETED,
        FAILED;

    }

    private static enum RequestState {
        TRANSIENT,
        QUEUED,
        BEGIN,
        HEADERS,
        COMMIT,
        CONTENT,
        FAILURE;

    }
}

