/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class TolerantSaxDocumentBuilder
extends DefaultHandler
implements LexicalHandler {
    private final DocumentBuilder documentBuilder;
    private final StringBuilder traceBuilder;
    private Document currentDocument;
    private Element currentElement;

    public TolerantSaxDocumentBuilder(DocumentBuilder documentBuilder) throws ParserConfigurationException {
        this.documentBuilder = documentBuilder;
        this.traceBuilder = new StringBuilder();
    }

    public Document getDocument() {
        return this.currentDocument;
    }

    public String getTrace() {
        return this.traceBuilder.toString();
    }

    @Override
    public void startDocument() throws SAXException {
        this.traceBuilder.delete(0, this.traceBuilder.length());
        this.trace("startDocument");
        this.currentDocument = this.documentBuilder.newDocument();
        this.currentElement = null;
    }

    @Override
    public void endDocument() throws SAXException {
        this.trace("endDocument");
    }

    @Override
    public void characters(char[] data, int start, int length) {
        if (length >= 0) {
            String characterData = new String(data, start, length);
            this.trace("characters:" + characterData);
            if (this.currentElement == null) {
                this.warn("Can't append text node to null currentElement");
            } else {
                Text textNode = this.currentDocument.createTextNode(characterData);
                this.currentElement.appendChild(textNode);
            }
        } else {
            this.warn("characters called with negative length");
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.trace("startElement:" + localName + "~" + qName);
        Element newElement = this.createElement(namespaceURI, qName, atts);
        this.appendNode(newElement);
        this.currentElement = newElement;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.trace("endElement:" + localName + "~" + qName);
        if (this.currentElement == null) {
            this.warn(qName + ": endElement before any startElement");
            return;
        }
        boolean atDocumentRoot = false;
        boolean foundTagToEnd = false;
        Element startElement = this.currentElement;
        while (!foundTagToEnd && !atDocumentRoot) {
            Node parentNode = this.currentElement.getParentNode();
            if (parentNode.getNodeType() == 1) {
                foundTagToEnd = TolerantSaxDocumentBuilder.isElementMatching(this.currentElement, qName);
                this.currentElement = (Element)parentNode;
                continue;
            }
            if (parentNode.getNodeType() == 9) {
                atDocumentRoot = true;
                if (startElement == this.currentDocument.getDocumentElement()) {
                    foundTagToEnd = TolerantSaxDocumentBuilder.isElementMatching(startElement, qName);
                    continue;
                }
                this.currentElement = startElement;
                continue;
            }
            throw new IllegalArgumentException("Closing element " + qName + ": expecting a parent ELEMENT_NODE but found " + parentNode);
        }
        if (!foundTagToEnd) {
            this.warn(qName + ": endElement does not match startElement!");
        }
    }

    private static boolean isElementMatching(Element anElement, String qname) {
        return anElement.getNodeName() != null && anElement.getNodeName().equals(qname);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.unhandled("endPrefixMapping");
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.unhandled("ignorableWhitespace");
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.trace("processingInstruction");
        ProcessingInstruction instruction = this.currentDocument.createProcessingInstruction(target, data);
        this.appendNode(instruction);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.unhandled("setDocumentLocator");
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.unhandled("skippedEntity");
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.unhandled("startPrefixMapping");
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.unhandled("startDTD");
    }

    @Override
    public void endDTD() throws SAXException {
        this.unhandled("endDTD");
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.unhandled("startEntity");
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.unhandled("endEntity");
    }

    @Override
    public void startCDATA() throws SAXException {
        this.unhandled("startCDATA");
    }

    @Override
    public void endCDATA() throws SAXException {
        this.unhandled("endCDATA");
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        String commentText = new String(ch, start, length);
        this.trace("comment:" + commentText);
        Comment comment = this.currentDocument.createComment(commentText);
        this.appendNode(comment);
    }

    private void unhandled(String method2) {
        this.trace("Unhandled callback: " + method2);
    }

    private void warn(String msg) {
        this.trace("WARNING: " + msg);
    }

    private void trace(String method2) {
        this.traceBuilder.append(method2).append('\n');
    }

    private Element createElement(String namespaceURI, String qName, Attributes attributes) {
        Element newElement = this.currentDocument.createElement(qName);
        if (namespaceURI != null && namespaceURI.length() > 0) {
            newElement.setPrefix(namespaceURI);
        }
        for (int i = 0; attributes != null && i < attributes.getLength(); ++i) {
            newElement.setAttribute(attributes.getQName(i), attributes.getValue(i));
        }
        return newElement;
    }

    private void appendNode(Node appendNode) {
        if (this.currentElement == null) {
            this.currentDocument.appendChild(appendNode);
        } else {
            this.currentElement.appendChild(appendNode);
        }
    }
}

