/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class WireMockClassRule
extends WireMockServer
implements MethodRule,
TestRule {
    public WireMockClassRule(Options options) {
        super(options);
    }

    public WireMockClassRule(int port, Integer httpsPort) {
        this(WireMockConfiguration.wireMockConfig().port(port).httpsPort(httpsPort));
    }

    public WireMockClassRule(int port) {
        this(WireMockConfiguration.wireMockConfig().port(port));
    }

    public WireMockClassRule() {
        this(WireMockConfiguration.wireMockConfig());
    }

    public Statement apply(Statement base, FrameworkMethod method2, Object target) {
        return this.apply(base, null);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                if (WireMockClassRule.this.isRunning()) {
                    try {
                        WireMockClassRule.this.before();
                        base.evaluate();
                    }
                    finally {
                        WireMockClassRule.this.after();
                        WireMockClassRule.this.client.resetMappings();
                    }
                }
                WireMockClassRule.this.start();
                WireMock.configureFor("localhost", WireMockClassRule.this.port());
                try {
                    WireMockClassRule.this.before();
                    base.evaluate();
                }
                finally {
                    WireMockClassRule.this.after();
                    WireMockClassRule.this.stop();
                }
            }
        };
    }

    protected void before() {
    }

    protected void after() {
    }
}

