/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.InputStreamSource;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public class BinaryFile
implements InputStreamSource {
    private URI uri;

    public BinaryFile(URI uri) {
        this.uri = uri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readContents() {
        try (InputStream stream = this.getStream();){
            byte[] byArray = ByteStreams.toByteArray(stream);
            return byArray;
        }
        catch (IOException ioe) {
            return Exceptions.throwUnchecked(ioe, byte[].class);
        }
    }

    protected URI getUri() {
        return this.uri;
    }

    public String name() {
        return this.uri.toString();
    }

    public String toString() {
        return this.name();
    }

    @Override
    public InputStream getStream() {
        try {
            return this.uri.toURL().openStream();
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, InputStream.class);
        }
    }
}

