/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.logging.LoggingHandler;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.ConnectionObserver;
import reactor.netty.DisposableServer;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.server.HttpRequestDecoderSpec;
import reactor.netty.http.server.HttpServerBind;
import reactor.netty.http.server.HttpServerConfiguration;
import reactor.netty.http.server.HttpServerHandle;
import reactor.netty.http.server.HttpServerObserve;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.HttpServerRoutes;
import reactor.netty.http.server.HttpServerSecure;
import reactor.netty.http.server.HttpServerTcpConfig;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpServer;
import reactor.util.Logger;
import reactor.util.Loggers;

public abstract class HttpServer {
    static final TcpServer DEFAULT_TCP_SERVER = TcpServer.create();
    static final LoggingHandler LOGGING_HANDLER = new LoggingHandler(HttpServer.class);
    static final Logger log = Loggers.getLogger(HttpServer.class);
    static final Function<TcpServer, TcpServer> COMPRESS_ATTR_CONFIG = tcp -> tcp.bootstrap(HttpServerConfiguration.MAP_COMPRESS);
    static final Function<TcpServer, TcpServer> COMPRESS_ATTR_DISABLE = tcp -> tcp.bootstrap(HttpServerConfiguration.MAP_NO_COMPRESS);
    static final Function<TcpServer, TcpServer> FORWARD_ATTR_CONFIG = tcp -> tcp.bootstrap(HttpServerConfiguration.MAP_FORWARDED);
    static final Function<TcpServer, TcpServer> FORWARD_ATTR_DISABLE = tcp -> tcp.bootstrap(HttpServerConfiguration.MAP_NO_FORWARDED);

    public static HttpServer create() {
        return HttpServerBind.INSTANCE;
    }

    public static HttpServer from(TcpServer tcpServer) {
        return new HttpServerBind(tcpServer);
    }

    public final Mono<? extends DisposableServer> bind() {
        return this.bind(this.tcpConfiguration());
    }

    public final DisposableServer bindNow() {
        return this.bindNow(Duration.ofSeconds(45L));
    }

    public final DisposableServer bindNow(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        try {
            return Objects.requireNonNull(this.bind().block(timeout), "aborted");
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("blocking read")) {
                throw new IllegalStateException("HttpServer couldn't be started within " + timeout.toMillis() + "ms");
            }
            throw e;
        }
    }

    public final void bindUntilJavaShutdown(Duration timeout, @Nullable Consumer<DisposableServer> onStart) {
        Objects.requireNonNull(timeout, "timeout");
        DisposableServer facade = this.bindNow();
        Objects.requireNonNull(facade, "facade");
        if (onStart != null) {
            onStart.accept(facade);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> facade.disposeNow(timeout)));
        facade.onDispose().block();
    }

    public final HttpServer compress(boolean compressionEnabled) {
        if (compressionEnabled) {
            return this.tcpConfiguration(COMPRESS_ATTR_CONFIG);
        }
        return this.tcpConfiguration(COMPRESS_ATTR_DISABLE);
    }

    public final HttpServer compress(int minResponseSize) {
        if (minResponseSize < 0) {
            throw new IllegalArgumentException("minResponseSize must be positive");
        }
        return this.tcpConfiguration(tcp -> tcp.bootstrap(b -> HttpServerConfiguration.compressSize(b, minResponseSize)));
    }

    public final HttpServer compress(BiPredicate<HttpServerRequest, HttpServerResponse> predicate) {
        Objects.requireNonNull(predicate, "compressionPredicate");
        return this.tcpConfiguration(tcp -> tcp.bootstrap(b -> HttpServerConfiguration.compressPredicate(b, predicate)));
    }

    public final HttpServer forwarded(boolean forwardedEnabled) {
        if (forwardedEnabled) {
            return this.tcpConfiguration(FORWARD_ATTR_CONFIG);
        }
        return this.tcpConfiguration(FORWARD_ATTR_DISABLE);
    }

    public final HttpServer host(String host) {
        return this.tcpConfiguration(tcpServer -> tcpServer.host(host));
    }

    public final HttpServer handle(BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return new HttpServerHandle(this, handler);
    }

    public final HttpServer httpRequestDecoder(Function<HttpRequestDecoderSpec, HttpRequestDecoderSpec> requestDecoderOptions) {
        return this.tcpConfiguration(requestDecoderOptions.apply(new HttpRequestDecoderSpec()).build());
    }

    public final HttpServer cookieCodec(ServerCookieEncoder encoder) {
        ServerCookieDecoder decoder = encoder == ServerCookieEncoder.LAX ? ServerCookieDecoder.LAX : ServerCookieDecoder.STRICT;
        return this.tcpConfiguration(tcp -> tcp.bootstrap(b -> HttpServerConfiguration.cookieCodec(b, encoder, decoder)));
    }

    public final HttpServer cookieCodec(ServerCookieEncoder encoder, ServerCookieDecoder decoder) {
        return this.tcpConfiguration(tcp -> tcp.bootstrap(b -> HttpServerConfiguration.cookieCodec(b, encoder, decoder)));
    }

    public final HttpServer observe(ConnectionObserver observer) {
        return new HttpServerObserve(this, observer);
    }

    public final HttpServer protocol(HttpProtocol ... supportedProtocols) {
        return this.tcpConfiguration(tcpServer -> tcpServer.bootstrap(b -> HttpServerConfiguration.protocols(b, supportedProtocols)));
    }

    public final HttpServer port(int port) {
        return this.tcpConfiguration(tcpServer -> tcpServer.port(port));
    }

    public final HttpServer secure(Consumer<? super SslProvider.SslContextSpec> sslProviderBuilder) {
        return new HttpServerSecure(this, sslProviderBuilder);
    }

    public final HttpServer route(Consumer<? super HttpServerRoutes> routesBuilder) {
        Objects.requireNonNull(routesBuilder, "routeBuilder");
        HttpServerRoutes routes = HttpServerRoutes.newRoutes();
        routesBuilder.accept(routes);
        return this.handle(routes);
    }

    public final HttpServer tcpConfiguration(Function<? super TcpServer, ? extends TcpServer> tcpMapper) {
        return new HttpServerTcpConfig(this, tcpMapper);
    }

    @Deprecated
    public final HttpServer wiretap() {
        return this.tcpConfiguration(tcpServer -> tcpServer.bootstrap(b -> BootstrapHandlers.updateLogSupport(b, LOGGING_HANDLER)));
    }

    public final HttpServer wiretap(boolean enable) {
        if (enable) {
            return this.tcpConfiguration(tcpServer -> tcpServer.bootstrap(b -> BootstrapHandlers.updateLogSupport(b, LOGGING_HANDLER)));
        }
        return this.tcpConfiguration(tcpServer -> tcpServer.bootstrap(b -> BootstrapHandlers.removeConfiguration(b, "reactor.left.loggingHandler")));
    }

    protected abstract Mono<? extends DisposableServer> bind(TcpServer var1);

    protected TcpServer tcpConfiguration() {
        return DEFAULT_TCP_SERVER;
    }
}

