/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient;

import reactivefeign.ReactiveFeign;
import reactivefeign.ReactiveOptions;
import reactivefeign.webclient.CustomizableWebClientBuilder;
import reactivefeign.webclient.WebClientFeignCustomizer;
import reactivefeign.webclient.WebReactiveOptions;
import reactivefeign.webclient.client.WebReactiveHttpClient;

public class WebReactiveFeign {
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(WebClientFeignCustomizer webClientCustomizer) {
        return new Builder(webClientCustomizer);
    }

    public static class Builder<T>
    extends ReactiveFeign.Builder<T> {
        protected CustomizableWebClientBuilder webClientBuilder = new CustomizableWebClientBuilder();

        protected Builder() {
            this.updateClientFactory();
        }

        protected Builder(WebClientFeignCustomizer webClientCustomizer) {
            webClientCustomizer.accept(this.webClientBuilder);
            this.updateClientFactory();
        }

        @Override
        public Builder<T> options(ReactiveOptions options) {
            this.webClientBuilder.setWebOptions((WebReactiveOptions)options);
            this.updateClientFactory();
            return this;
        }

        protected void updateClientFactory() {
            this.clientFactory(methodMetadata -> WebReactiveHttpClient.webClient(methodMetadata, this.webClientBuilder.build()));
        }
    }
}

