/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.publisher.retry;

import feign.MethodMetadata;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactivefeign.publisher.PublisherHttpClient;
import reactivefeign.utils.FeignUtils;
import reactor.core.publisher.Flux;

public abstract class RetryPublisherHttpClient
implements PublisherHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(RetryPublisherHttpClient.class);
    private final String feignMethodTag;
    protected final PublisherHttpClient publisherClient;
    protected final Function<Flux<Throwable>, Flux<?>> retryFunction;

    protected RetryPublisherHttpClient(PublisherHttpClient publisherClient, MethodMetadata methodMetadata, Function<Flux<Throwable>, Flux<Throwable>> retryFunction) {
        this.publisherClient = publisherClient;
        this.feignMethodTag = FeignUtils.methodTag(methodMetadata);
        this.retryFunction = RetryPublisherHttpClient.wrapWithLog(retryFunction, this.feignMethodTag);
    }

    protected Function<Throwable, Throwable> outOfRetries() {
        return throwable -> {
            logger.error("[{}]---> USED ALL RETRIES", (Object)this.feignMethodTag, throwable);
            return throwable;
        };
    }

    protected static Function<Flux<Throwable>, Flux<?>> wrapWithLog(Function<Flux<Throwable>, Flux<Throwable>> retryFunction, String feignMethodTag) {
        return throwableFlux -> ((Flux)retryFunction.apply((Flux<Throwable>)throwableFlux)).doOnNext(throwable -> {
            if (logger.isDebugEnabled()) {
                logger.debug("[{}]---> RETRYING on error", (Object)feignMethodTag, throwable);
            }
        });
    }
}

