/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.result.condition.AbstractRequestCondition;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;

public final class PatternsRequestCondition
extends AbstractRequestCondition<PatternsRequestCondition> {
    private final SortedSet<PathPattern> patterns;

    public PatternsRequestCondition(PathPattern ... patterns) {
        this(Arrays.asList(patterns));
    }

    public PatternsRequestCondition(List<PathPattern> patterns) {
        this(new TreeSet<PathPattern>(patterns));
    }

    private PatternsRequestCondition(SortedSet<PathPattern> patterns) {
        this.patterns = patterns;
    }

    public Set<PathPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    protected Collection<PathPattern> getContent() {
        return this.patterns;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public PatternsRequestCondition combine(PatternsRequestCondition other) {
        ArrayList<PathPattern> combined = new ArrayList<PathPattern>();
        if (!this.patterns.isEmpty() && !other.patterns.isEmpty()) {
            for (PathPattern pattern1 : this.patterns) {
                for (PathPattern pattern2 : other.patterns) {
                    combined.add(pattern1.combine(pattern2));
                }
            }
        } else if (!this.patterns.isEmpty()) {
            combined.addAll(this.patterns);
        } else if (!other.patterns.isEmpty()) {
            combined.addAll(other.patterns);
        }
        return new PatternsRequestCondition(combined);
    }

    @Override
    @Nullable
    public PatternsRequestCondition getMatchingCondition(ServerWebExchange exchange2) {
        if (this.patterns.isEmpty()) {
            return this;
        }
        SortedSet<PathPattern> matches = this.getMatchingPatterns(exchange2);
        return !matches.isEmpty() ? new PatternsRequestCondition(matches) : null;
    }

    private SortedSet<PathPattern> getMatchingPatterns(ServerWebExchange exchange2) {
        PathContainer lookupPath = exchange2.getRequest().getPath().pathWithinApplication();
        return this.patterns.stream().filter(pattern -> pattern.matches(lookupPath)).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public int compareTo(PatternsRequestCondition other, ServerWebExchange exchange2) {
        Iterator iterator = this.patterns.iterator();
        Iterator<PathPattern> iteratorOther = other.getPatterns().iterator();
        while (iterator.hasNext() && iteratorOther.hasNext()) {
            int result = PathPattern.SPECIFICITY_COMPARATOR.compare((PathPattern)iterator.next(), iteratorOther.next());
            if (result == 0) continue;
            return result;
        }
        if (iterator.hasNext()) {
            return -1;
        }
        if (iteratorOther.hasNext()) {
            return 1;
        }
        return 0;
    }
}

