/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Metadata
extends LinkedHashMap<String, Object> {
    public Metadata() {
    }

    public Metadata(Map<? extends String, ?> data) {
        super(data);
    }

    public Integer getInt(String key) {
        return this.checkValidityAndCast(key, Integer.class);
    }

    public Boolean getBoolean(String key) {
        return this.checkValidityAndCast(key, Boolean.class);
    }

    public String getString(String key) {
        return this.checkValidityAndCast(key, String.class);
    }

    public List<?> getList(String key) {
        return this.checkValidityAndCast(key, List.class);
    }

    public Metadata getMetadata(String key) {
        this.checkKeyPresent(key);
        Preconditions.checkArgument(Map.class.isAssignableFrom(this.get(key).getClass()), key + " is not a map");
        return new Metadata((Map)this.get(key));
    }

    private <T> T checkValidityAndCast(String key, Class<T> type) {
        this.checkKeyPresent(key);
        Preconditions.checkArgument(type.isAssignableFrom(this.get(key).getClass()), key + " is not of type " + type.getSimpleName());
        return (T)this.get(key);
    }

    private void checkKeyPresent(String key) {
        Preconditions.checkArgument(this.containsKey(key), key + "' not present");
    }

    public static Builder metadata() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, Object> mapBuilder = ImmutableMap.builder();

        public Builder attr(String key, Object value) {
            this.mapBuilder.put(key, value);
            return this;
        }

        public Builder list(String key, Object ... values) {
            this.mapBuilder.put(key, ImmutableList.copyOf(values));
            return this;
        }

        public Builder attr(String key, Builder metadataBuilder) {
            this.mapBuilder.put(key, metadataBuilder.build());
            return this;
        }

        public Metadata build() {
            return new Metadata((Map<? extends String, ?>)this.mapBuilder.build());
        }
    }
}

