/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.NonBlocking;
import reactor.netty.FutureMono;
import reactor.netty.resources.DefaultLoop;
import reactor.netty.resources.DefaultLoopNativeDetector;
import reactor.netty.resources.LoopResources;

final class DefaultLoopResources
extends AtomicLong
implements LoopResources {
    final String prefix;
    final boolean daemon;
    final int selectCount;
    final int workerCount;
    final AtomicReference<EventLoopGroup> serverLoops;
    final AtomicReference<EventLoopGroup> clientLoops;
    final AtomicReference<EventLoopGroup> serverSelectLoops;
    final AtomicReference<EventLoopGroup> cacheNativeClientLoops;
    final AtomicReference<EventLoopGroup> cacheNativeServerLoops;
    final AtomicReference<EventLoopGroup> cacheNativeSelectLoops;
    final AtomicBoolean running = new AtomicBoolean(true);

    static ThreadFactory threadFactory(DefaultLoopResources parent, String prefix) {
        return new EventLoopFactory(parent.daemon, parent.prefix + "-" + prefix, parent);
    }

    DefaultLoopResources(String prefix, int workerCount, boolean daemon) {
        this(prefix, -1, workerCount, daemon);
    }

    DefaultLoopResources(String prefix, int selectCount, int workerCount, boolean daemon) {
        this.daemon = daemon;
        this.workerCount = workerCount;
        this.prefix = prefix;
        this.serverLoops = new AtomicReference();
        this.clientLoops = new AtomicReference();
        this.cacheNativeClientLoops = new AtomicReference();
        this.cacheNativeServerLoops = new AtomicReference();
        if (selectCount == -1) {
            this.selectCount = workerCount;
            this.serverSelectLoops = this.serverLoops;
            this.cacheNativeSelectLoops = this.cacheNativeServerLoops;
        } else {
            this.selectCount = selectCount;
            this.serverSelectLoops = new AtomicReference();
            this.cacheNativeSelectLoops = new AtomicReference();
        }
    }

    @Override
    public boolean isDisposed() {
        return !this.running.get();
    }

    @Override
    public Mono<Void> disposeLater() {
        return Mono.defer(() -> {
            EventLoopGroup serverLoopsGroup = this.serverLoops.get();
            EventLoopGroup clientLoopsGroup = this.clientLoops.get();
            EventLoopGroup serverSelectLoopsGroup = this.serverSelectLoops.get();
            EventLoopGroup cacheNativeClientGroup = this.cacheNativeClientLoops.get();
            EventLoopGroup cacheNativeSelectGroup = this.cacheNativeSelectLoops.get();
            EventLoopGroup cacheNativeServerGroup = this.cacheNativeServerLoops.get();
            Mono<Object> clMono = Mono.empty();
            Mono<Object> sslMono = Mono.empty();
            Mono<Object> slMono = Mono.empty();
            Mono<Object> cnclMono = Mono.empty();
            Mono<Object> cnslMono = Mono.empty();
            Mono<Object> cnsrvlMono = Mono.empty();
            if (this.running.compareAndSet(true, false)) {
                if (clientLoopsGroup != null) {
                    clMono = FutureMono.from(clientLoopsGroup.shutdownGracefully());
                }
                if (serverSelectLoopsGroup != null) {
                    sslMono = FutureMono.from(serverSelectLoopsGroup.shutdownGracefully());
                }
                if (serverLoopsGroup != null) {
                    slMono = FutureMono.from(serverLoopsGroup.shutdownGracefully());
                }
                if (cacheNativeClientGroup != null) {
                    cnclMono = FutureMono.from(cacheNativeClientGroup.shutdownGracefully());
                }
                if (cacheNativeSelectGroup != null) {
                    cnslMono = FutureMono.from(cacheNativeSelectGroup.shutdownGracefully());
                }
                if (cacheNativeServerGroup != null) {
                    cnsrvlMono = FutureMono.from(cacheNativeServerGroup.shutdownGracefully());
                }
            }
            return Mono.when(clMono, sslMono, slMono, cnclMono, cnslMono, cnsrvlMono);
        });
    }

    @Override
    public EventLoopGroup onServerSelect(boolean useNative) {
        if (useNative && this.preferNative()) {
            return this.cacheNativeSelectLoops();
        }
        return this.cacheNioSelectLoops();
    }

    EventLoopGroup cacheNioSelectLoops() {
        if (this.serverSelectLoops == this.serverLoops) {
            return this.cacheNioServerLoops();
        }
        EventLoopGroup eventLoopGroup = this.serverSelectLoops.get();
        if (null == eventLoopGroup) {
            NioEventLoopGroup newEventLoopGroup = new NioEventLoopGroup(this.selectCount, DefaultLoopResources.threadFactory(this, "select-nio"));
            if (!this.serverSelectLoops.compareAndSet(null, newEventLoopGroup)) {
                newEventLoopGroup.shutdownGracefully();
            }
            eventLoopGroup = this.cacheNioSelectLoops();
        }
        return eventLoopGroup;
    }

    @Override
    public EventLoopGroup onServer(boolean useNative) {
        if (useNative && this.preferNative()) {
            return this.cacheNativeServerLoops();
        }
        return this.cacheNioServerLoops();
    }

    EventLoopGroup cacheNioServerLoops() {
        EventLoopGroup eventLoopGroup = this.serverLoops.get();
        if (null == eventLoopGroup) {
            NioEventLoopGroup newEventLoopGroup = new NioEventLoopGroup(this.workerCount, DefaultLoopResources.threadFactory(this, "nio"));
            if (!this.serverLoops.compareAndSet(null, newEventLoopGroup)) {
                newEventLoopGroup.shutdownGracefully();
            }
            eventLoopGroup = this.cacheNioServerLoops();
        }
        return eventLoopGroup;
    }

    @Override
    public EventLoopGroup onClient(boolean useNative) {
        if (useNative && this.preferNative()) {
            return this.cacheNativeClientLoops();
        }
        return this.cacheNioClientLoops();
    }

    EventLoopGroup cacheNioClientLoops() {
        EventLoopGroup eventLoopGroup = this.clientLoops.get();
        if (null == eventLoopGroup) {
            EventLoopGroup newEventLoopGroup = LoopResources.colocate(this.cacheNioServerLoops());
            if (!this.clientLoops.compareAndSet(null, newEventLoopGroup)) {
                // empty if block
            }
            eventLoopGroup = this.cacheNioClientLoops();
        }
        return eventLoopGroup;
    }

    @Override
    public String toString() {
        return "DefaultLoopResources {prefix=" + this.prefix + ", daemon=" + this.daemon + ", selectCount=" + this.selectCount + ", workerCount=" + this.workerCount + '}';
    }

    EventLoopGroup cacheNativeSelectLoops() {
        if (this.cacheNativeSelectLoops == this.cacheNativeServerLoops) {
            return this.cacheNativeServerLoops();
        }
        EventLoopGroup eventLoopGroup = this.cacheNativeSelectLoops.get();
        if (null == eventLoopGroup) {
            DefaultLoop defaultLoop = DefaultLoopNativeDetector.getInstance();
            EventLoopGroup newEventLoopGroup = defaultLoop.newEventLoopGroup(this.selectCount, DefaultLoopResources.threadFactory(this, "select-" + defaultLoop.getName()));
            if (!this.cacheNativeSelectLoops.compareAndSet(null, newEventLoopGroup)) {
                newEventLoopGroup.shutdownGracefully();
            }
            eventLoopGroup = this.cacheNativeSelectLoops();
        }
        return eventLoopGroup;
    }

    EventLoopGroup cacheNativeServerLoops() {
        EventLoopGroup eventLoopGroup = this.cacheNativeServerLoops.get();
        if (null == eventLoopGroup) {
            DefaultLoop defaultLoop = DefaultLoopNativeDetector.getInstance();
            EventLoopGroup newEventLoopGroup = defaultLoop.newEventLoopGroup(this.workerCount, DefaultLoopResources.threadFactory(this, defaultLoop.getName()));
            if (!this.cacheNativeServerLoops.compareAndSet(null, newEventLoopGroup)) {
                newEventLoopGroup.shutdownGracefully();
            }
            eventLoopGroup = this.cacheNativeServerLoops();
        }
        return eventLoopGroup;
    }

    EventLoopGroup cacheNativeClientLoops() {
        EventLoopGroup eventLoopGroup = this.cacheNativeClientLoops.get();
        if (null == eventLoopGroup) {
            EventLoopGroup newEventLoopGroup = LoopResources.colocate(this.cacheNativeServerLoops());
            if (!this.cacheNativeClientLoops.compareAndSet(null, newEventLoopGroup)) {
                // empty if block
            }
            eventLoopGroup = this.cacheNativeClientLoops();
        }
        return eventLoopGroup;
    }

    static final class EventLoop
    extends Thread
    implements NonBlocking {
        EventLoop(Runnable target) {
            super(target);
        }
    }

    static final class EventLoopFactory
    implements ThreadFactory {
        final boolean daemon;
        final AtomicLong counter;
        final String prefix;

        EventLoopFactory(boolean daemon, String prefix, AtomicLong counter) {
            this.daemon = daemon;
            this.counter = counter;
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            EventLoop t = new EventLoop(r);
            t.setDaemon(this.daemon);
            t.setName(this.prefix + "-" + this.counter.incrementAndGet());
            return t;
        }
    }
}

