/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.Supplier;

final class UriEndpoint {
    final String scheme;
    final String host;
    final int port;
    final Supplier<SocketAddress> remoteAddress;
    final String pathAndQuery;

    UriEndpoint(String scheme, String host, int port, Supplier<SocketAddress> remoteAddress, String pathAndQuery) {
        this.host = host;
        this.port = port;
        this.scheme = Objects.requireNonNull(scheme, "scheme");
        this.remoteAddress = Objects.requireNonNull(remoteAddress, "remoteAddressSupplier");
        this.pathAndQuery = Objects.requireNonNull(pathAndQuery, "pathAndQuery");
    }

    boolean isWs() {
        return "ws".equals(this.scheme) || "wss".equals(this.scheme);
    }

    boolean isSecure() {
        return UriEndpoint.isSecureScheme(this.scheme);
    }

    static boolean isSecureScheme(String scheme) {
        return "https".equals(scheme) || "wss".equals(scheme);
    }

    String getPathAndQuery() {
        return this.pathAndQuery;
    }

    SocketAddress getRemoteAddress() {
        return this.remoteAddress.get();
    }

    String toExternalForm() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.scheme);
        sb.append("://");
        SocketAddress address = this.remoteAddress.get();
        sb.append(address != null ? UriEndpoint.toSocketAddressStringWithoutDefaultPort(address, this.isSecure()) : "localhost");
        sb.append(this.pathAndQuery);
        return sb.toString();
    }

    static String toSocketAddressStringWithoutDefaultPort(SocketAddress address, boolean secure) {
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalStateException("Only support InetSocketAddress representation");
        }
        String addressString = NetUtil.toSocketAddressString((InetSocketAddress)address);
        if (secure) {
            if (addressString.endsWith(":443")) {
                addressString = addressString.substring(0, addressString.length() - 4);
            }
        } else if (addressString.endsWith(":80")) {
            addressString = addressString.substring(0, addressString.length() - 3);
        }
        return addressString;
    }

    public String toString() {
        return this.toExternalForm();
    }
}

