/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.publisher.retry;

import feign.MethodMetadata;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.publisher.PublisherHttpClient;
import reactivefeign.publisher.retry.RetryPublisherHttpClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MonoRetryPublisherHttpClient
extends RetryPublisherHttpClient {
    public MonoRetryPublisherHttpClient(PublisherHttpClient publisherClient, MethodMetadata methodMetadata, Function<Flux<Throwable>, Flux<Throwable>> retryFunction) {
        super(publisherClient, methodMetadata, retryFunction);
    }

    @Override
    public Publisher<Object> executeRequest(ReactiveHttpRequest request) {
        Mono response = (Mono)this.publisherClient.executeRequest(request);
        return response.retryWhen(this.retryFunction).onErrorMap(this.outOfRetries());
    }
}

