/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.benchmarks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.jetty9.JettyHttpServer;
import feign.Feign;
import feign.Util;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.springframework.web.reactive.function.client.WebClient;
import reactivefeign.benchmarks.BenchmarkUtils;
import reactivefeign.benchmarks.FeignReactorTestInterface;
import reactivefeign.benchmarks.FeignTestInterface;
import reactivefeign.java11.Java11ReactiveFeign;
import reactivefeign.java11.Java11ReactiveOptions;
import reactivefeign.jetty.JettyReactiveFeign;
import reactivefeign.jetty.JettyReactiveOptions;
import reactivefeign.webclient.WebReactiveFeign;
import reactor.core.publisher.Mono;
import rx.Observable;

public abstract class RealRequestBenchmarks {
    public static final String PATH_WITH_PAYLOAD = "/withPayload";
    public static final int SERVER_PORT = 8766;
    public static final int SERVER_H2C_PORT = 8767;
    public static final String SERVER_URL = "http://localhost:8767";
    public static final String SERVER_H2C_URL = "http://localhost:8767";
    private Server serverJettyH2c;
    protected WebClient webClient;
    protected FeignReactorTestInterface webClientFeign;
    protected HttpClient jettyHttpClient;
    protected FeignReactorTestInterface jettyFeign;
    protected HttpClient jettyH2cClient;
    protected FeignReactorTestInterface jettyFeignH2c;
    protected FeignReactorTestInterface java11Feign;
    protected FeignReactorTestInterface java11FeignH2c;
    protected FeignTestInterface feign;
    protected byte[] responseJson;
    protected Map<String, Object> requestPayload;
    protected ObjectMapper objectMapper;

    protected void setup() throws Exception {
        this.responseJson = BenchmarkUtils.readJsonFromFileAsBytes("/response.json");
        this.objectMapper = new ObjectMapper();
        this.requestPayload = this.objectMapper.readValue(BenchmarkUtils.readJsonFromFile("/request.json"), HashMap.class);
        this.serverJettyH2c = this.jettyH2c(8767);
        this.serverJettyH2c.start();
        this.webClient = WebClient.create();
        this.webClientFeign = WebReactiveFeign.builder().target(FeignReactorTestInterface.class, "http://localhost:8767");
        this.jettyHttpClient = new HttpClient();
        this.jettyHttpClient.setMaxConnectionsPerDestination(10000);
        this.jettyHttpClient.start();
        this.jettyFeign = JettyReactiveFeign.builder(this.jettyHttpClient).target(FeignReactorTestInterface.class, "http://localhost:8767");
        HTTP2Client h2Client = new HTTP2Client();
        h2Client.setSelectors(1);
        HttpClientTransportOverHTTP2 transport = new HttpClientTransportOverHTTP2(h2Client);
        this.jettyH2cClient = new HttpClient(transport, null);
        this.jettyH2cClient.start();
        this.jettyFeignH2c = JettyReactiveFeign.builder().options(new JettyReactiveOptions.Builder().setUseHttp2(true).build()).target(FeignReactorTestInterface.class, "http://localhost:8767");
        this.jettyFeignH2c.postWithPayload(Mono.just(Collections.emptyMap())).block();
        this.java11Feign = Java11ReactiveFeign.builder().target(FeignReactorTestInterface.class, "http://localhost:8767");
        this.java11FeignH2c = Java11ReactiveFeign.builder().options(new Java11ReactiveOptions.Builder().setUseHttp2(true).build()).target(FeignReactorTestInterface.class, "http://localhost:8767");
        this.java11FeignH2c.postWithPayload(Mono.just(Collections.emptyMap())).block();
        this.feign = Feign.builder().encoder((o, type, requestTemplate) -> {
            try {
                requestTemplate.body(this.objectMapper.writeValueAsString(o));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).decoder((response, type) -> type == String.class ? Util.toString(response.body().asReader()) : this.objectMapper.readValue(response.body().asInputStream(), (Class)((ParameterizedType)type).getRawType())).target(FeignTestInterface.class, "http://localhost:8767");
    }

    protected void tearDown() throws Exception {
        this.serverJettyH2c.stop();
        ((QueuedThreadPool)this.jettyHttpClient.getExecutor()).stop();
        this.jettyHttpClient.stop();
        this.jettyH2cClient.stop();
    }

    private HttpServer<ByteBuf, ByteBuf> rxNetty(int port) {
        return RxNetty.createHttpServer(port, new RequestHandler<ByteBuf, ByteBuf>(){

            @Override
            public Observable<Void> handle(HttpServerRequest<ByteBuf> request, HttpServerResponse<ByteBuf> response) {
                if (request.getPath().equals(RealRequestBenchmarks.PATH_WITH_PAYLOAD)) {
                    response.getHeaders().add("Content-Type", (Object)"application/json");
                    response.writeBytes(RealRequestBenchmarks.this.responseJson);
                }
                return response.flush();
            }
        });
    }

    private Server jettyH2c(int port) {
        Server serverJetty = new Server();
        serverJetty.setHandler(new AbstractHandler(){

            @Override
            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                request.getInputStream().skip(Integer.MAX_VALUE);
                if (target.equals(RealRequestBenchmarks.PATH_WITH_PAYLOAD)) {
                    response.addHeader("Content-Type", "application/json");
                    response.getOutputStream().write(RealRequestBenchmarks.this.responseJson);
                    response.getOutputStream().flush();
                }
                baseRequest.setHandled(true);
            }
        });
        HttpConfiguration httpConfig = new HttpConfiguration();
        ServerConnector connectorH2c = new ServerConnector(serverJetty, new HttpConnectionFactory(httpConfig), new HTTP2CServerConnectionFactory(httpConfig));
        connectorH2c.setPort(port);
        serverJetty.addConnector(connectorH2c);
        return serverJetty;
    }

    private WireMockServer wireMockH2c(int port) {
        WireMockServer server = new WireMockServer(this.wireMockConfig().port(port).asynchronousResponseEnabled(true));
        server.stubFor(WireMock.get(WireMock.urlEqualTo("/")).willReturn(WireMock.aResponse().withStatus(200)));
        server.stubFor(WireMock.post(WireMock.urlEqualTo(PATH_WITH_PAYLOAD)).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody(this.responseJson)));
        return server;
    }

    private WireMockConfiguration wireMockConfig() {
        return WireMockConfiguration.wireMockConfig().httpServerFactory((options, adminRequestHandler, stubRequestHandler) -> new JettyHttpServer(options, adminRequestHandler, stubRequestHandler){

            @Override
            protected ServerConnector createHttpConnector(String bindAddress, int port, JettySettings jettySettings, NetworkTrafficListener listener) {
                HttpConfiguration httpConfig = this.createHttpConfig(jettySettings);
                return this.createServerConnector(bindAddress, jettySettings, port, listener, new HttpConnectionFactory(httpConfig), new HTTP2CServerConnectionFactory(httpConfig));
            }
        });
    }
}

