/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.result.view.RequestContext;
import org.springframework.web.reactive.result.view.RequestDataValueProcessor;
import org.springframework.web.reactive.result.view.View;
import org.springframework.web.reactive.result.view.ViewResolverSupport;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractView
implements View,
BeanNameAware,
ApplicationContextAware {
    public static final String REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME = "requestDataValueProcessor";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final Object NO_VALUE = new Object();
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;
    private final List<MediaType> mediaTypes = new ArrayList<MediaType>(4);
    private Charset defaultCharset = StandardCharsets.UTF_8;
    @Nullable
    private String requestContextAttribute;
    @Nullable
    private String beanName;
    @Nullable
    private ApplicationContext applicationContext;

    public AbstractView() {
        this(ReactiveAdapterRegistry.getSharedInstance());
    }

    public AbstractView(ReactiveAdapterRegistry reactiveAdapterRegistry) {
        this.reactiveAdapterRegistry = reactiveAdapterRegistry;
        this.mediaTypes.add(ViewResolverSupport.DEFAULT_CONTENT_TYPE);
    }

    public void setSupportedMediaTypes(List<MediaType> supportedMediaTypes) {
        Assert.notEmpty(supportedMediaTypes, "MediaType List must not be empty");
        this.mediaTypes.clear();
        this.mediaTypes.addAll(supportedMediaTypes);
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return this.mediaTypes;
    }

    public void setDefaultCharset(Charset defaultCharset) {
        Assert.notNull((Object)defaultCharset, "'defaultCharset' must not be null");
        this.defaultCharset = defaultCharset;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setRequestContextAttribute(@Nullable String requestContextAttribute) {
        this.requestContextAttribute = requestContextAttribute;
    }

    @Nullable
    public String getRequestContextAttribute() {
        return this.requestContextAttribute;
    }

    @Override
    public void setBeanName(@Nullable String beanName) {
        this.beanName = beanName;
    }

    @Nullable
    public String getBeanName() {
        return this.beanName;
    }

    public void setApplicationContext(@Nullable ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Nullable
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected final ApplicationContext obtainApplicationContext() {
        ApplicationContext applicationContext = this.getApplicationContext();
        Assert.state(applicationContext != null, "No ApplicationContext");
        return applicationContext;
    }

    @Override
    public Mono<Void> render(@Nullable Map<String, ?> model, @Nullable MediaType contentType2, ServerWebExchange exchange2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(exchange2.getLogPrefix() + "View " + this.formatViewName() + ", model " + (model != null ? model : Collections.emptyMap()));
        }
        if (contentType2 != null) {
            exchange2.getResponse().getHeaders().setContentType(contentType2);
        }
        return this.getModelAttributes(model, exchange2).flatMap(mergedModel -> {
            if (this.requestContextAttribute != null) {
                mergedModel.put(this.requestContextAttribute, this.createRequestContext(exchange2, (Map<String, Object>)mergedModel));
            }
            return this.renderInternal((Map<String, Object>)mergedModel, contentType2, exchange2);
        });
    }

    protected Mono<Map<String, Object>> getModelAttributes(@Nullable Map<String, ?> model, ServerWebExchange exchange2) {
        int size = model != null ? model.size() : 0;
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>(size);
        if (model != null) {
            attributes.putAll(model);
        }
        return this.resolveAsyncAttributes(attributes).then(Mono.just(attributes));
    }

    protected Mono<Void> resolveAsyncAttributes(Map<String, Object> model) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Mono<Object>> valueMonos = new ArrayList<Mono<Object>>();
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            ReactiveAdapter adapter;
            Object value = entry.getValue();
            if (value == null || (adapter = this.reactiveAdapterRegistry.getAdapter(null, value)) == null) continue;
            names.add(entry.getKey());
            if (adapter.isMultiValue()) {
                Flux fluxValue = Flux.from(adapter.toPublisher(value));
                valueMonos.add(fluxValue.collectList().defaultIfEmpty(Collections.emptyList()));
                continue;
            }
            Mono<Object> monoValue = Mono.from(adapter.toPublisher(value));
            valueMonos.add(monoValue.defaultIfEmpty(NO_VALUE));
        }
        if (names.isEmpty()) {
            return Mono.empty();
        }
        return Mono.zip(valueMonos, values -> {
            for (int i = 0; i < ((Object[])values).length; ++i) {
                if (values[i] != NO_VALUE) {
                    model.put((String)names.get(i), values[i]);
                    continue;
                }
                model.remove(names.get(i));
            }
            return NO_VALUE;
        }).then();
    }

    protected RequestContext createRequestContext(ServerWebExchange exchange2, Map<String, Object> model) {
        return new RequestContext(exchange2, model, (MessageSource)this.obtainApplicationContext(), this.getRequestDataValueProcessor());
    }

    @Nullable
    protected RequestDataValueProcessor getRequestDataValueProcessor() {
        ApplicationContext context = this.getApplicationContext();
        if (context != null && context.containsBean(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME)) {
            return (RequestDataValueProcessor)context.getBean(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME, RequestDataValueProcessor.class);
        }
        return null;
    }

    protected abstract Mono<Void> renderInternal(Map<String, Object> var1, @Nullable MediaType var2, ServerWebExchange var3);

    public String toString() {
        return this.getClass().getName() + ": " + this.formatViewName();
    }

    protected String formatViewName() {
        return this.getBeanName() != null ? "name '" + this.getBeanName() + "'" : "[" + this.getClass().getSimpleName() + "]";
    }
}

