/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverComposite;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class InvocableHandlerMethod
extends HandlerMethod {
    private static final Mono<Object[]> EMPTY_ARGS = Mono.just(new Object[0]);
    private static final Object NO_ARG_VALUE = new Object();
    private HandlerMethodArgumentResolverComposite resolvers = new HandlerMethodArgumentResolverComposite();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private ReactiveAdapterRegistry reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();

    public InvocableHandlerMethod(HandlerMethod handlerMethod) {
        super(handlerMethod);
    }

    public InvocableHandlerMethod(Object bean, Method method2) {
        super(bean, method2);
    }

    public void setArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        this.resolvers.addResolvers(resolvers);
    }

    public List<HandlerMethodArgumentResolver> getResolvers() {
        return this.resolvers.getResolvers();
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer nameDiscoverer) {
        this.parameterNameDiscoverer = nameDiscoverer;
    }

    public ParameterNameDiscoverer getParameterNameDiscoverer() {
        return this.parameterNameDiscoverer;
    }

    public void setReactiveAdapterRegistry(ReactiveAdapterRegistry registry) {
        this.reactiveAdapterRegistry = registry;
    }

    public Mono<HandlerResult> invoke(ServerWebExchange exchange2, BindingContext bindingContext, Object ... providedArgs) {
        return this.getMethodArgumentValues(exchange2, bindingContext, providedArgs).flatMap(args -> {
            Object value;
            try {
                ReflectionUtils.makeAccessible(this.getBridgedMethod());
                value = this.getBridgedMethod().invoke(this.getBean(), args);
            }
            catch (IllegalArgumentException ex) {
                this.assertTargetBean(this.getBridgedMethod(), this.getBean(), (Object[])args);
                String text = ex.getMessage() != null ? ex.getMessage() : "Illegal argument";
                return Mono.error(new IllegalStateException(this.formatInvokeError(text, (Object[])args), ex));
            }
            catch (InvocationTargetException ex) {
                return Mono.error(ex.getTargetException());
            }
            catch (Throwable ex) {
                return Mono.error(new IllegalStateException(this.formatInvokeError("Invocation failure", (Object[])args), ex));
            }
            HttpStatus status = this.getResponseStatus();
            if (status != null) {
                exchange2.getResponse().setStatusCode(status);
            }
            MethodParameter returnType = this.getReturnType();
            ReactiveAdapter adapter = this.reactiveAdapterRegistry.getAdapter(returnType.getParameterType());
            boolean asyncVoid = InvocableHandlerMethod.isAsyncVoidReturnType(returnType, adapter);
            if ((value == null || asyncVoid) && this.isResponseHandled((Object[])args, exchange2)) {
                return asyncVoid ? Mono.from(adapter.toPublisher(value)) : Mono.empty();
            }
            HandlerResult result = new HandlerResult(this, value, returnType, bindingContext);
            return Mono.just(result);
        });
    }

    private Mono<Object[]> getMethodArgumentValues(ServerWebExchange exchange2, BindingContext bindingContext, Object ... providedArgs) {
        if (ObjectUtils.isEmpty(this.getMethodParameters())) {
            return EMPTY_ARGS;
        }
        MethodParameter[] parameters = this.getMethodParameters();
        ArrayList argMonos = new ArrayList(parameters.length);
        for (MethodParameter parameter : parameters) {
            parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
            Object providedArg = InvocableHandlerMethod.findProvidedArgument(parameter, providedArgs);
            if (providedArg != null) {
                argMonos.add(Mono.just(providedArg));
                continue;
            }
            if (!this.resolvers.supportsParameter(parameter)) {
                return Mono.error(new IllegalStateException(InvocableHandlerMethod.formatArgumentError(parameter, "No suitable resolver")));
            }
            try {
                argMonos.add(this.resolvers.resolveArgument(parameter, bindingContext, exchange2).defaultIfEmpty(NO_ARG_VALUE).doOnError(cause -> this.logArgumentErrorIfNecessary(exchange2, parameter, (Throwable)cause)));
            }
            catch (Exception ex) {
                this.logArgumentErrorIfNecessary(exchange2, parameter, ex);
                argMonos.add(Mono.error(ex));
            }
        }
        return Mono.zip(argMonos, values -> Stream.of(values).map(o -> o != NO_ARG_VALUE ? o : null).toArray());
    }

    private void logArgumentErrorIfNecessary(ServerWebExchange exchange2, MethodParameter parameter, Throwable cause) {
        String message = cause.getMessage();
        if (!message.contains(parameter.getExecutable().toGenericString()) && this.logger.isDebugEnabled()) {
            this.logger.debug(exchange2.getLogPrefix() + InvocableHandlerMethod.formatArgumentError(parameter, message));
        }
    }

    private static boolean isAsyncVoidReturnType(MethodParameter returnType, @Nullable ReactiveAdapter adapter) {
        if (adapter != null && adapter.supportsEmpty()) {
            ParameterizedType type;
            if (adapter.isNoValue()) {
                return true;
            }
            Type parameterType = returnType.getGenericParameterType();
            if (parameterType instanceof ParameterizedType && (type = (ParameterizedType)parameterType).getActualTypeArguments().length == 1) {
                return Void.class.equals((Object)type.getActualTypeArguments()[0]);
            }
        }
        return false;
    }

    private boolean isResponseHandled(Object[] args, ServerWebExchange exchange2) {
        if (this.getResponseStatus() != null || exchange2.isNotModified()) {
            return true;
        }
        for (Object arg : args) {
            if (!(arg instanceof ServerHttpResponse) && !(arg instanceof ServerWebExchange)) continue;
            return true;
        }
        return false;
    }
}

