/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.github.tomakehurst.wiremock.common.ContentTypes;
import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import java.util.Arrays;
import java.util.Objects;

public class Body {
    private final byte[] content;
    private final boolean binary;

    public Body(byte[] content) {
        this(content, true);
    }

    private Body(byte[] content, boolean binary) {
        this.content = content;
        this.binary = binary;
    }

    public Body(String content) {
        this.content = Strings.bytesFromString(content);
        this.binary = false;
    }

    public Body(JsonNode content) {
        this.content = Json.toByteArray(content);
        this.binary = false;
    }

    static Body fromBytes(byte[] bytes) {
        return bytes != null ? new Body(bytes) : Body.none();
    }

    static Body fromString(String str) {
        return str != null ? new Body(str) : Body.none();
    }

    public static Body ofBinaryOrText(byte[] content, ContentTypeHeader contentTypeHeader) {
        return new Body(content, ContentTypes.determineIsTextFromMimeType(contentTypeHeader.mimeTypePart()));
    }

    public static Body fromOneOf(byte[] bytes, String str, JsonNode json, String base64) {
        if (bytes != null) {
            return new Body(bytes);
        }
        if (str != null) {
            return new Body(str);
        }
        if (json != null && !(json instanceof NullNode)) {
            return new Body(json);
        }
        if (base64 != null) {
            return new Body(Encoding.decodeBase64(base64), true);
        }
        return Body.none();
    }

    public static Body none() {
        return new Body((byte[])null);
    }

    public String asString() {
        return this.content != null ? Strings.stringFromBytes(this.content) : null;
    }

    public byte[] asBytes() {
        return this.content != null ? this.content : null;
    }

    public String asBase64() {
        return Encoding.encodeBase64(this.content);
    }

    public boolean isBinary() {
        return this.binary;
    }

    public boolean isAbsent() {
        return this.content == null;
    }

    public boolean isPresent() {
        return !this.isAbsent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Body body2 = (Body)o;
        return Objects.equals(this.binary, body2.binary) && Arrays.equals(this.content, body2.content);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.binary);
    }

    public String toString() {
        return "Body {content=" + this.asString() + ", binary=" + this.binary + '}';
    }
}

