/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.util.AttributeKey;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.NettyOutbound;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.client.HttpClientRequest;

final class HttpClientConfiguration {
    static final HttpClientConfiguration DEFAULT = new HttpClientConfiguration();
    static final AttributeKey<HttpClientConfiguration> CONF_KEY = AttributeKey.newInstance("httpClientConf");
    boolean acceptGzip = false;
    boolean followRedirect = false;
    Boolean chunkedTransfer = null;
    String uri = null;
    String baseUrl = null;
    HttpHeaders headers = null;
    HttpMethod method = HttpMethod.GET;
    String websocketSubprotocols = null;
    int websocketMaxFramePayloadLength = 65536;
    int protocols = 4;
    ClientCookieEncoder cookieEncoder = ClientCookieEncoder.STRICT;
    ClientCookieDecoder cookieDecoder = ClientCookieDecoder.STRICT;
    Function<Mono<HttpClientConfiguration>, Mono<HttpClientConfiguration>> deferredConf = null;
    BiFunction<? super HttpClientRequest, ? super NettyOutbound, ? extends Publisher<Void>> body;
    static final Function<Bootstrap, Bootstrap> MAP_KEEPALIVE = b -> {
        HttpClientConfiguration c = HttpClientConfiguration.getOrCreate(b);
        if (c.headers == null) {
            return b;
        }
        HttpUtil.setKeepAlive(c.headers, HttpVersion.HTTP_1_1, true);
        return b;
    };
    static final Function<Bootstrap, Bootstrap> MAP_NO_KEEPALIVE = b -> {
        HttpClientConfiguration c = HttpClientConfiguration.getOrCreate(b);
        if (c.headers == null) {
            c.headers = new DefaultHttpHeaders();
        }
        HttpUtil.setKeepAlive(c.headers, HttpVersion.HTTP_1_1, false);
        return b;
    };
    static final Function<Bootstrap, Bootstrap> MAP_COMPRESS = b -> {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).acceptGzip = true;
        return b;
    };
    static final Function<Bootstrap, Bootstrap> MAP_NO_COMPRESS = b -> {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).acceptGzip = false;
        return b;
    };
    static final Function<Bootstrap, Bootstrap> MAP_CHUNKED = b -> {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).chunkedTransfer = true;
        return b;
    };
    static final Function<Bootstrap, Bootstrap> MAP_NO_CHUNKED = b -> {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).chunkedTransfer = false;
        return b;
    };
    static final Function<Bootstrap, Bootstrap> MAP_REDIRECT = b -> {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).followRedirect = true;
        return b;
    };
    static final Function<Bootstrap, Bootstrap> MAP_NO_REDIRECT = b -> {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).followRedirect = false;
        return b;
    };
    static final int h11 = 4;
    static final int h2 = 2;
    static final int h2c = 1;
    static final int h11orH2c = 5;

    HttpClientConfiguration() {
    }

    HttpClientConfiguration(HttpClientConfiguration from) {
        this.uri = from.uri;
        this.acceptGzip = from.acceptGzip;
        this.followRedirect = from.followRedirect;
        this.cookieEncoder = from.cookieEncoder;
        this.cookieDecoder = from.cookieDecoder;
        this.chunkedTransfer = from.chunkedTransfer;
        this.baseUrl = from.baseUrl;
        this.headers = from.headers;
        this.method = from.method;
        this.websocketSubprotocols = from.websocketSubprotocols;
        this.websocketMaxFramePayloadLength = from.websocketMaxFramePayloadLength;
        this.body = from.body;
    }

    static HttpClientConfiguration getAndClean(Bootstrap b) {
        HttpClientConfiguration hcc = (HttpClientConfiguration)b.config().attrs().get(CONF_KEY);
        b.attr(CONF_KEY, null);
        if (hcc == null) {
            hcc = DEFAULT;
        }
        return hcc;
    }

    static HttpClientConfiguration getOrCreate(Bootstrap b) {
        HttpClientConfiguration hcc = (HttpClientConfiguration)b.config().attrs().get(CONF_KEY);
        if (hcc == null) {
            hcc = new HttpClientConfiguration();
            b.attr(CONF_KEY, hcc);
        }
        return hcc;
    }

    static HttpClientConfiguration get(Bootstrap b) {
        HttpClientConfiguration hcc = (HttpClientConfiguration)b.config().attrs().get(CONF_KEY);
        if (hcc == null) {
            return DEFAULT;
        }
        return hcc;
    }

    static Bootstrap uri(Bootstrap b, String uri) {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).uri = uri;
        return b;
    }

    HttpClientConfiguration uri(String uri) {
        this.uri = uri;
        return this;
    }

    static Bootstrap baseUrl(Bootstrap b, String baseUrl) {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).baseUrl = baseUrl;
        return b;
    }

    static Bootstrap deferredConf(Bootstrap b, Function<HttpClientConfiguration, Mono<HttpClientConfiguration>> deferrer) {
        HttpClientConfiguration c = HttpClientConfiguration.getOrCreate(b);
        c.deferredConf = c.deferredConf != null ? c.deferredConf.andThen(deferredConf -> deferredConf.flatMap(deferrer)) : deferredConf -> deferredConf.flatMap(deferrer);
        return b;
    }

    static Bootstrap headers(Bootstrap b, HttpHeaders headers2) {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).headers = headers2;
        return b;
    }

    HttpClientConfiguration headers(HttpHeaders headers2) {
        this.headers = headers2;
        return this;
    }

    @Nullable
    static HttpHeaders headers(Bootstrap b) {
        HttpClientConfiguration hcc = (HttpClientConfiguration)b.config().attrs().get(CONF_KEY);
        if (hcc == null) {
            return null;
        }
        return hcc.headers;
    }

    static Bootstrap method(Bootstrap b, HttpMethod method2) {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).method = method2;
        return b;
    }

    static Bootstrap body(Bootstrap b, BiFunction<? super HttpClientRequest, ? super NettyOutbound, ? extends Publisher<Void>> body2) {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).body = body2;
        return b;
    }

    static Bootstrap protocols(Bootstrap b, HttpProtocol ... protocols) {
        int _protocols = 0;
        for (HttpProtocol p : protocols) {
            if (p == HttpProtocol.HTTP11) {
                _protocols |= 4;
                continue;
            }
            if (p == HttpProtocol.H2) {
                _protocols |= 2;
                continue;
            }
            if (p != HttpProtocol.H2C) continue;
            _protocols |= 1;
        }
        HttpClientConfiguration.getOrCreate((Bootstrap)b).protocols = _protocols;
        return b;
    }

    static Bootstrap websocketSubprotocols(Bootstrap b, String websocketSubprotocols) {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).websocketSubprotocols = websocketSubprotocols;
        return b;
    }

    static Bootstrap websocketMaxFramePayloadLength(Bootstrap b, int websocketMaxFramePayloadLength) {
        HttpClientConfiguration.getOrCreate((Bootstrap)b).websocketMaxFramePayloadLength = websocketMaxFramePayloadLength;
        return b;
    }

    static Bootstrap cookieCodec(Bootstrap b, ClientCookieEncoder encoder, ClientCookieDecoder decoder) {
        HttpClientConfiguration conf = HttpClientConfiguration.getOrCreate(b);
        conf.cookieEncoder = encoder;
        conf.cookieDecoder = decoder;
        return b;
    }
}

