/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.utils;

import feign.MethodMetadata;
import feign.Util;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import org.reactivestreams.Publisher;

public class FeignUtils {
    public static String methodTag(MethodMetadata methodMetadata) {
        return methodMetadata.configKey().substring(0, methodMetadata.configKey().indexOf(40));
    }

    public static Class returnPublisherType(MethodMetadata methodMetadata) {
        Type returnType = methodMetadata.returnType();
        return (Class)((ParameterizedType)returnType).getRawType();
    }

    public static Type returnActualType(MethodMetadata methodMetadata) {
        return Util.resolveLastTypeParameter(methodMetadata.returnType(), FeignUtils.returnPublisherType(methodMetadata));
    }

    public static Type bodyActualType(MethodMetadata methodMetadata) {
        return FeignUtils.getBodyActualType(methodMetadata.bodyType());
    }

    public static Type getBodyActualType(Type bodyType) {
        return Optional.ofNullable(bodyType).map(type -> {
            if (type instanceof ParameterizedType) {
                Class bodyClass = (Class)((ParameterizedType)type).getRawType();
                if (Publisher.class.isAssignableFrom(bodyClass)) {
                    return Util.resolveLastTypeParameter(bodyType, bodyClass);
                }
                return type;
            }
            return type;
        }).orElse(null);
    }
}

