/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.publisher;

import feign.MethodMetadata;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactivefeign.publisher.PublisherHttpClient;
import reactivefeign.utils.FeignUtils;
import reactor.core.publisher.Flux;

public abstract class RetryPublisherHttpClient<P extends PublisherHttpClient>
implements PublisherHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(RetryPublisherHttpClient.class);
    private final String feignMethodTag;
    protected final P publisherClient;
    protected final Function<Flux<Throwable>, Flux<?>> retryFunction;

    protected RetryPublisherHttpClient(P publisherClient, MethodMetadata methodMetadata, Function<Flux<Throwable>, Flux<Throwable>> retryFunction) {
        this.publisherClient = publisherClient;
        this.feignMethodTag = FeignUtils.methodTag(methodMetadata);
        this.retryFunction = RetryPublisherHttpClient.wrapWithLog(retryFunction, this.feignMethodTag);
    }

    protected Function<Throwable, Throwable> outOfRetries() {
        return throwable -> {
            logger.debug("[{}]---> USED ALL RETRIES", (Object)this.feignMethodTag, throwable);
            return new OutOfRetriesException((Throwable)throwable, this.feignMethodTag);
        };
    }

    protected static Function<Flux<Throwable>, Flux<?>> wrapWithLog(Function<Flux<Throwable>, Flux<Throwable>> retryFunction, String feignMethodTag) {
        return throwableFlux -> ((Flux)retryFunction.apply((Flux<Throwable>)throwableFlux)).doOnNext(throwable -> {
            if (logger.isDebugEnabled()) {
                logger.debug("[{}]---> RETRYING on error", (Object)feignMethodTag, throwable);
            }
        });
    }

    public static class OutOfRetriesException
    extends Exception {
        OutOfRetriesException(Throwable cause, String feignMethodTag) {
            super("All retries used for: " + feignMethodTag, cause);
        }
    }
}

