/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.jetty.client;

import com.fasterxml.jackson.core.async_.JsonFactory;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.reactivestreams.Publisher;
import reactivefeign.client.ReactiveHttpResponse;
import reactivejson.ReactorObjectReader;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class JettyReactiveHttpResponse
implements ReactiveHttpResponse {
    public static final String CHARSET_DELIMITER = ";charset=";
    private final Response clientResponse;
    private final Publisher<ContentChunk> contentChunks;
    private final Class returnPublisherType;
    private Class<?> returnActualClass;
    private final ObjectReader objectReader;
    private final JsonFactory jsonFactory;

    JettyReactiveHttpResponse(Response clientResponse, Publisher<ContentChunk> contentChunks, Class returnPublisherType, Class returnActualClass, JsonFactory jsonFactory, ObjectReader objectReader) {
        this.clientResponse = clientResponse;
        this.contentChunks = contentChunks;
        this.returnPublisherType = returnPublisherType;
        this.returnActualClass = returnActualClass;
        this.objectReader = objectReader;
        this.jsonFactory = jsonFactory;
    }

    @Override
    public int status() {
        return this.clientResponse.getStatus();
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.clientResponse.getHeaders().stream().collect(Collectors.toMap(HttpField::getName, field -> Arrays.asList(field.getValues())));
    }

    @Override
    public Publisher<?> body() {
        ReactorObjectReader reactorObjectReader = new ReactorObjectReader(this.jsonFactory);
        Flux<ByteBuffer> content = this.directContent();
        if (this.returnActualClass == ByteBuffer.class) {
            return content;
        }
        if (this.returnActualClass.isAssignableFrom(String.class) && this.returnPublisherType == Mono.class) {
            Charset charset = this.getCharset();
            return content.map(byteBuffer -> charset.decode((ByteBuffer)byteBuffer).toString());
        }
        if (this.returnPublisherType == Mono.class) {
            return reactorObjectReader.read(content, this.objectReader);
        }
        if (this.returnPublisherType == Flux.class) {
            return reactorObjectReader.readElements(content, this.objectReader);
        }
        throw new IllegalArgumentException("Unknown returnPublisherType: " + this.returnPublisherType);
    }

    private Charset getCharset() {
        return Optional.ofNullable(this.clientResponse.getHeaders().get(HttpHeader.CONTENT_TYPE.asString())).map(header -> {
            int pos = header.indexOf(CHARSET_DELIMITER);
            if (pos >= 0) {
                return header.substring(pos + CHARSET_DELIMITER.length());
            }
            return null;
        }).map(Charset::forName).orElse(StandardCharsets.UTF_8);
    }

    private Flux<ByteBuffer> directContent() {
        return Flux.from(this.contentChunks).map(contentChunk -> contentChunk.buffer.slice());
    }

    @Override
    public Mono<byte[]> bodyData() {
        return this.joinChunks();
    }

    private Mono<byte[]> joinChunks() {
        return this.directContent().reduce(new ByteArrayOutputStream(), (baos, byteBuffer) -> {
            int limit = byteBuffer.limit();
            for (int i = byteBuffer.position(); i < limit; ++i) {
                baos.write(byteBuffer.get(i));
            }
            return baos;
        }).map(ByteArrayOutputStream::toByteArray);
    }
}

