/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.jetty;

import com.fasterxml.jackson.core.async_.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.eclipse.jetty.client.HttpClient;
import reactivefeign.ReactiveFeign;
import reactivefeign.ReactiveOptions;
import reactivefeign.jetty.JettyReactiveOptions;
import reactivefeign.jetty.client.JettyReactiveHttpClient;

public final class JettyReactiveFeign {
    private JettyReactiveFeign() {
    }

    public static <T> Builder<T> builder() {
        try {
            HttpClient httpClient = new HttpClient();
            httpClient.start();
            return JettyReactiveFeign.builder(httpClient);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Builder<T> builder(HttpClient httpClient) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        return JettyReactiveFeign.builder(httpClient, new JsonFactory(), objectMapper);
    }

    public static <T> Builder<T> builder(HttpClient httpClient, JsonFactory jsonFactory, ObjectMapper objectMapper) {
        return new Builder(httpClient, jsonFactory, objectMapper);
    }

    public static class Builder<T>
    extends ReactiveFeign.Builder<T> {
        protected HttpClient httpClient;
        protected JsonFactory jsonFactory;
        private ObjectMapper objectMapper;
        protected JettyReactiveOptions options;

        protected Builder(HttpClient httpClient, JsonFactory jsonFactory, ObjectMapper objectMapper) {
            this.setHttpClient(httpClient, jsonFactory, objectMapper);
            this.jsonFactory = jsonFactory;
            this.objectMapper = objectMapper;
        }

        @Override
        public Builder<T> options(ReactiveOptions options) {
            this.options = (JettyReactiveOptions)options;
            if (this.options.getConnectTimeoutMillis() != null) {
                this.httpClient.setConnectTimeout(options.getConnectTimeoutMillis());
            }
            if (this.options.getRequestTimeoutMillis() != null) {
                this.setHttpClient(this.httpClient, this.jsonFactory, this.objectMapper);
            }
            return this;
        }

        protected void setHttpClient(HttpClient httpClient, JsonFactory jsonFactory, ObjectMapper objectMapper) {
            this.httpClient = httpClient;
            this.clientFactory(methodMetadata -> {
                JettyReactiveHttpClient jettyClient = JettyReactiveHttpClient.jettyClient(methodMetadata, httpClient, jsonFactory, objectMapper);
                if (this.options != null && this.options.getRequestTimeoutMillis() != null) {
                    jettyClient = jettyClient.setRequestTimeout(this.options.getRequestTimeoutMillis());
                }
                if (this.options != null && this.options.isTryUseCompression() != null) {
                    jettyClient = jettyClient.setTryUseCompression(this.options.isTryUseCompression());
                }
                return jettyClient;
            });
        }
    }
}

