/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.jetty;

import com.fasterxml.jackson.core.async_.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import reactivefeign.jetty.JettyReactiveFeign;

public final class JettyHttp2ReactiveFeign {
    private JettyHttp2ReactiveFeign() {
    }

    public static <T> JettyReactiveFeign.Builder<T> builder() {
        try {
            HTTP2Client h2Client = new HTTP2Client();
            h2Client.setSelectors(1);
            HttpClientTransportOverHTTP2 transport = new HttpClientTransportOverHTTP2(h2Client);
            HttpClient httpClient = new HttpClient(transport, null);
            httpClient.start();
            return JettyHttp2ReactiveFeign.builder(httpClient);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> JettyReactiveFeign.Builder<T> builder(HttpClient httpClient) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        return JettyHttp2ReactiveFeign.builder(httpClient, new JsonFactory(), objectMapper);
    }

    public static <T> JettyReactiveFeign.Builder<T> builder(HttpClient httpClient, JsonFactory jsonFactory, ObjectMapper objectMapper) {
        if (!(httpClient.getTransport() instanceof HttpClientTransportOverHTTP2)) {
            throw new IllegalArgumentException("HttpClient should use HttpClientTransportOverHTTP2");
        }
        return new JettyReactiveFeign.Builder(httpClient, jsonFactory, objectMapper);
    }
}

