/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client;

import feign.MethodMetadata;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactivefeign.client.DelegatingReactiveHttpResponse;
import reactivefeign.client.ReactiveHttpClient;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.utils.FeignUtils;
import reactivefeign.utils.Pair;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class LoggerReactiveHttpClient
implements ReactiveHttpClient {
    private final Logger logger = LoggerFactory.getLogger(LoggerReactiveHttpClient.class);
    private final ReactiveHttpClient reactiveClient;
    private final String methodTag;

    public static ReactiveHttpClient log(ReactiveHttpClient reactiveClient, MethodMetadata methodMetadata) {
        return new LoggerReactiveHttpClient(reactiveClient, methodMetadata);
    }

    private LoggerReactiveHttpClient(ReactiveHttpClient reactiveClient, MethodMetadata methodMetadata) {
        this.reactiveClient = reactiveClient;
        this.methodTag = FeignUtils.methodTag(methodMetadata);
    }

    @Override
    public Mono<ReactiveHttpResponse> executeRequest(ReactiveHttpRequest request) {
        AtomicLong start = new AtomicLong(-1L);
        return Mono.defer(() -> {
            start.set(System.currentTimeMillis());
            return Mono.just(request);
        }).flatMap(req -> {
            req = this.logRequest(this.methodTag, (ReactiveHttpRequest)req);
            return this.reactiveClient.executeRequest((ReactiveHttpRequest)req).doOnNext(resp -> this.logResponseHeaders(this.methodTag, (ReactiveHttpResponse)resp, System.currentTimeMillis() - start.get()));
        }).map(resp -> new LoggerReactiveHttpResponse((ReactiveHttpResponse)resp, start));
    }

    private ReactiveHttpRequest logRequest(String feignMethodTag, ReactiveHttpRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}]--->{} {} HTTP/1.1", feignMethodTag, request.method(), request.uri());
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] REQUEST HEADERS\n{}", (Object)feignMethodTag, (Object)LoggerReactiveHttpClient.msg(() -> request.headers().entrySet().stream().map(entry -> String.format("%s:%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("\n"))));
            if (request.body() != null) {
                Publisher<Object> bodyLogged;
                if (request.body() instanceof Mono) {
                    bodyLogged = ((Mono)request.body()).doOnNext(body2 -> this.logger.trace("[{}] REQUEST BODY\n{}", (Object)feignMethodTag, body2));
                } else if (request.body() instanceof Flux) {
                    bodyLogged = ((Flux)request.body()).doOnNext(body2 -> this.logger.trace("[{}] REQUEST BODY ELEMENT\n{}", (Object)feignMethodTag, body2));
                } else {
                    throw new IllegalArgumentException("Unsupported publisher type: " + request.body().getClass());
                }
                return new ReactiveHttpRequest(request, bodyLogged);
            }
        }
        return request;
    }

    private void logResponseHeaders(String feignMethodTag, ReactiveHttpResponse httpResponse, long elapsedTime) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] RESPONSE HEADERS\n{}", (Object)feignMethodTag, (Object)LoggerReactiveHttpClient.msg(() -> httpResponse.headers().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> new Pair<String, String>((String)entry.getKey(), (String)value))).map(pair -> String.format("%s:%s", pair.left, pair.right)).collect(Collectors.joining("\n"))));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}]<--- headers takes {} milliseconds", (Object)feignMethodTag, (Object)elapsedTime);
        }
    }

    private void logResponseBodyAndTime(String feignMethodTag, Object response, long elapsedTime, boolean mono) {
        if (this.logger.isTraceEnabled()) {
            if (mono) {
                this.logger.trace("[{}] RESPONSE BODY\n{}", (Object)feignMethodTag, response);
            } else {
                this.logger.trace("[{}] RESPONSE BODY ELEMENT\n{}", (Object)feignMethodTag, response);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}]<--- body takes {} milliseconds", (Object)feignMethodTag, (Object)elapsedTime);
        }
    }

    private static MessageSupplier msg(Supplier<?> supplier) {
        return new MessageSupplier(supplier);
    }

    static class MessageSupplier {
        private Supplier<?> supplier;

        public MessageSupplier(Supplier<?> supplier) {
            this.supplier = supplier;
        }

        public String toString() {
            return this.supplier.get().toString();
        }
    }

    private class LoggerReactiveHttpResponse
    extends DelegatingReactiveHttpResponse {
        private final AtomicLong start;

        private LoggerReactiveHttpResponse(ReactiveHttpResponse response, AtomicLong start) {
            super(response);
            this.start = start;
        }

        @Override
        public Publisher<?> body() {
            Publisher<?> publisher = this.getResponse().body();
            if (publisher instanceof Mono) {
                return ((Mono)publisher).doOnNext(this.responseBodyLogger(this.start, true));
            }
            return ((Flux)publisher).doOnNext(this.responseBodyLogger(this.start, false));
        }

        @Override
        public Mono<byte[]> bodyData() {
            Mono<byte[]> publisher = this.getResponse().bodyData();
            return publisher.doOnNext(this.responseBodyLogger(this.start, true));
        }

        private Consumer<Object> responseBodyLogger(AtomicLong start, boolean mono) {
            return result -> LoggerReactiveHttpClient.this.logResponseBodyAndTime(LoggerReactiveHttpClient.this.methodTag, result, System.currentTimeMillis() - start.get(), mono);
        }
    }
}

