/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.benchmarks;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.springframework.http.HttpMethod;
import org.springframework.web.reactive.function.client.WebClient;
import reactivefeign.benchmarks.RealRequestBenchmarks;
import reactor.core.publisher.Mono;

@Measurement(iterations=5, time=1)
@Warmup(iterations=3, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
public class ParallelRequestBenchmarks
extends RealRequestBenchmarks {
    public static final int CALLS_NUMBER = 100;
    private ExecutorService executor;

    @Override
    @Setup
    public void setup() throws Exception {
        super.setup();
        this.executor = Executors.newFixedThreadPool(100);
    }

    @Override
    @TearDown
    public void tearDown() throws Exception {
        super.tearDown();
        this.executor.shutdown();
    }

    @Benchmark
    public void webClient() {
        Mono.zip(IntStream.range(0, 100).mapToObj(i -> ((WebClient.RequestBodySpec)this.webClient.method(HttpMethod.POST).uri("http://localhost:8767/withPayload", new Object[0])).body(Mono.just(this.requestPayload), Map.class).header("Content-Type", "application/json").retrieve().bodyToMono(Map.class)).collect(Collectors.toList()), values -> values).block();
    }

    @Benchmark
    public void feign() throws ExecutionException, InterruptedException {
        CompletableFuture[] bonusesCompletableFutures = (CompletableFuture[])IntStream.range(0, 100).mapToObj(runnable -> CompletableFuture.runAsync(() -> this.feign.postWithPayload(this.requestPayload), this.executor)).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(bonusesCompletableFutures).get();
    }

    @Benchmark
    public void feignWebClient() {
        Mono.zip(IntStream.range(0, 100).mapToObj(i -> this.webClientFeign.postWithPayload(Mono.just(this.requestPayload))).collect(Collectors.toList()), values -> values).block();
    }

    @Benchmark
    public void feignJetty() {
        Mono.zip(IntStream.range(0, 100).mapToObj(i -> this.jettyFeign.postWithPayload(Mono.just(this.requestPayload))).collect(Collectors.toList()), values -> values).block();
    }

    @Benchmark
    public void feignJettyH2c() {
        Mono.zip(IntStream.range(0, 100).mapToObj(i -> this.jettyFeignH2c.postWithPayload(Mono.just(this.requestPayload))).collect(Collectors.toList()), values -> values).block();
    }

    @Benchmark
    public void feignJava11() {
        Mono.zip(IntStream.range(0, 100).mapToObj(i -> this.java11Feign.postWithPayload(Mono.just(this.requestPayload))).collect(Collectors.toList()), values -> values).block();
    }

    @Benchmark
    public void feignJava11H2c() {
        Mono.zip(IntStream.range(0, 100).mapToObj(i -> this.java11FeignH2c.postWithPayload(Mono.just(this.requestPayload))).collect(Collectors.toList()), values -> values).block();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().jvmArgs("-Xms1024m", "-Xmx4024m").include(".*" + ParallelRequestBenchmarks.class.getSimpleName() + ".*").build();
        new Runner(opt).run();
    }
}

