/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign;

import feign.RetryableException;
import java.util.Date;
import reactivefeign.ReactiveRetryPolicy;

public final class ReactiveRetryers {
    private ReactiveRetryers() {
    }

    public static ReactiveRetryPolicy retry(int maxRetries) {
        return (error, attemptNo) -> attemptNo <= maxRetries ? 0L : -1L;
    }

    public static ReactiveRetryPolicy retryWithBackoff(int maxRetries, long periodInMs) {
        return (error, attemptNo) -> {
            if (attemptNo <= maxRetries) {
                long delay;
                Date retryAfter;
                if (error instanceof RetryableException && (retryAfter = ((RetryableException)error).retryAfter()) != null) {
                    delay = retryAfter.getTime() - System.currentTimeMillis();
                    delay = Math.min(delay, periodInMs);
                    delay = Math.max(delay, 0L);
                } else {
                    delay = periodInMs;
                }
                return delay;
            }
            return -1L;
        };
    }
}

